<?php
    /** @var \Illuminate\Support\Collection|\App\Models\Department[] $departments */
    /** @var \App\Models\Department $department */
    /** @var \Illuminate\Support\Collection|\App\Models\Code[] $departmentCodes */
?>


<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <img src="/images/logo_akademije_ng.png" class="w-50"/>
        </div>
        <br />
        <h1 class="text-center">
            Кодови за попуњавање анкете
        </h1>
        <h2 id="izabranStudProg" class="font-weight-bolder text-center"><?php 
        echo $department->name; ?></h2>
        <div class="row justify-content-center">
            <div id="studprogtabs" class="col-md-12 <?php if($department->id != null) echo 'd-none'; else echo ''; ?>">
                <legend class="text-center">
                    Изаберите студијски програм
                </legend>
                <?php echo $__env->make('admin.departments.navigation', [
                    'departments' => $departments,
                    'activeDepartment' => $department->id,
                    'routeLink' => 'codes.show',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            
            <?php if($department->id == null && $departmentCodes->count() == 0): ?>
            <script>activateTabs();</script>
            <?php elseif($department->id > 0 && $departmentCodes->count() > 0): ?>
            <script>deactivateTabs();</script>
            <br />
            <a class="font-weight-bolder" href="#"  onclick="activateTabs()">Изаберите други студијски програм</a>
            <br />
            <legend class="text-center">
                Изаберите семестар који сте слушали.
            </legend>
            <?php elseif($department->id != null && $departmentCodes->count() == 0): ?>
            <legend id="nemakodova" class="text-center">
                Нема више кодова за изабрани студијски програм. Уколико нисте попунили анкету обратите се на <a href="mailto:online@akademijanis.edu.rs"> online@akademijanis.edu.rs </a>
            </legend>
            <br />
                <a href="#" class="font-weight-bolder" style="font-size=2em;" onclick="activateTabs()">Изаберите други студијски програм</a>
            <br />
            <?php endif; ?>
            <script> 
            function activateTabs(){
                document.getElementById("izabranStudProg").classList.add("d-none");
                document.getElementById("studprogtabs").classList.remove("d-none");
                document.getElementById("nemakodova").classList.add("d-none");
            }
            function deactivateTabs(){
                document.getElementById("studprogtabs").classList.add("d-none");
                document.getElementById("izabranStudProg").classList.remove("d-none");
                changeCurrName();
            }
            </script>
            <?php if($department->id != null && $departmentCodes->count() != 0): ?>
            <div class="col-md-12">
                <ul class="nav nav-tabs" id="semesters" role="tablist">
                    <?php $__currentLoopData = $departmentCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a
                                class="nav-link"
                                id="<?php echo e($semester); ?>-tab"
                                data-toggle="tab"
                                href="#semester-<?php echo e($semester); ?>"
                                role="tab"
                                aria-controls="semester-<?php echo e($semester); ?>"
                                <?php if($loop->first): ?>
                                aria-selected="true"
                                <?php endif; ?>
                            ><?php echo e($semester); ?>. семестар</a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                
                <div class="tab-content mt-4">
                    <?php $__currentLoopData = $departmentCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane" id="semester-<?php echo e($semester); ?>" role="tabpanel" aria-labelledby="<?php echo e($semester); ?>-tab">
                            <a class="btn btn-secondary float-right w-25 mb-3" href="<?php echo e(route('login')); ?>">Започни анкету</a>
                            <legend>
                                Копирајте један од кодова испод и кликните на започни анкету.
                            </legend>
                            <table class="table table-bordered content-center">
                                <thead class="thead-dark">
                                <th scope="col" colspan="3" class="text-center">
                                    Кодови
                                </th>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $semesterCodes->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $codesChunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <?php $__currentLoopData = $codesChunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="text-center"><?php echo e($code->code); ?></td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akademij/public_html/anketaon/resources/views/codes.blade.php ENDPATH**/ ?>