<?php $__env->startSection('title', 'Кодови'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-2">
                <?php echo $__env->make('admin.departments.navigation', ['departments' => $departments, 'activeDepartment' => $department->id, 'routeLink' => 'admin.departments.codes.index'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-10">
                <div class="d-flex justify-content-between mb-3">
                    <div>
                        Број неискоришћених кодова за смер: <?php echo e($totalAvailableCodes); ?>

                        <br>
                        Број искоришћених кодова за смер: <?php echo e($totalUsedCodes); ?>

                    </div>
                    <div class="d-flex  justify-content-end">
                        <form>
                            <a class="btn btn-secondary mr-1" href="<?php echo e(route('admin.departments.codes.create', $department->id)); ?>">Генериши кодове</a>
                        </form>
                        

                            <form method="POST" action="<?php echo e(route('admin.departments.codes.delete', $department->id)); ?>" id="delete-form" onsubmit="$('#delete-modal').modal('toggle')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-danger ml-1 mr-1"
                                        type="button"
                                        data-toggle="modal"
                                        data-target="#delete-modal"
                                >Обриши кодове</button>
                                <?php echo $__env->make('layouts.password_confirm_modal', [
                                        'name' => 'delete-modal',
                                        'title' => 'Брисање неискоришћених кодова',
                                        'warning' => 'Да ли сте сигурни да желите да обришете неискоришћене кодове?',
                                        'text' => 'Унеси своју лозинку како би ресетовао анкету.',
                                        'action' => 'Обриши',
                                        'cancel' => 'Одустани',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </form>





                      
                        <?php if(Settings::get('codes-public')): ?>
                            <form action="<?php echo e(route('admin.codes.hide')); ?>" method="post">
                                <?php echo csrf_field(); ?>

                                <button type="submit" class="btn btn-secondary">Сакриј кодове</button>
                            </form>
                        <?php else: ?>
                            <form action="<?php echo e(route('admin.codes.publish')); ?>" method="post">
                                <?php echo csrf_field(); ?>

                                <button type="submit" class="btn btn-secondary">Објави кодове</button>
                            </form>
                        <?php endif; ?>


                    </div>
                </div>

              
                <ul class="nav nav-tabs" id="semesters" role="tablist">
                    <?php $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a
                                    class="nav-link <?php if($loop->first): ?> active <?php endif; ?> "
                                    id="<?php echo e($semester); ?>-tab"
                                    data-toggle="tab"
                                    href="#semester-<?php echo e($semester); ?>"
                                    role="tab"
                                    aria-controls="semester-<?php echo e($semester); ?>"
                                    <?php if($loop->first): ?>
                                    aria-selected="true"
                                    <?php endif; ?>
                            ><?php echo e($semester); ?>. семестар</a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="tab-content mt-4">
                    <?php $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $semesterCodes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane <?php if($loop->first): ?> active <?php endif; ?>" id="semester-<?php echo e($semester); ?>" role="tabpanel" aria-labelledby="<?php echo e($semester); ?>-tab">
                            <div class="d-flex justify-content-between mb-2">
                                <div>
                                    Број неискоришћених кодова за <?php echo e($semester); ?>. семестар: <?php echo e($semesterCodes->where('used', false)->count()); ?>

                                    <br>
                                    Број искоришћених кодова за <?php echo e($semester); ?>. семестар: <?php echo e($semesterCodes->where('used', true)->count()); ?>

                                </div>
                                <a
                                    href="<?php echo e(route('admin.codes.print', ['department' => $department, 'semester' => $semester])); ?>"
                                    target="_blank"
                                    class="btn btn-secondary">
                                    Одштампај кодове за <?php echo e($semester); ?>. семестар
                                </a>
                            </div>
                            <table class="table">
                                <thead class="thead-dark">
                                    <th scope="col">
                                        Код
                                    </th>
                                    <th scope="col">
                                        Смер
                                    </th>
                                    <th scope="col">
                                        Семестар
                                    </th>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $semesterCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th class="align-middle" scope="row"><?php echo e($code->code); ?></th>
                                            <td class="align-middle"><?php echo e($department->name); ?></td>
                                            <td class="align-middle"><?php echo e($semester); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php if($codes->isEmpty()): ?>
                    <div class="h2 text-center">
                        Нема неупотребљених кодова
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akademij/public_html/anketaon/resources/views/admin/codes/index.blade.php ENDPATH**/ ?>