<?php $__env->startSection('title', 'Извештаји'); ?>

<?php $__env->startSection('scripts'); ?>
    ##parent-placeholder-16728d18790deb58b3b8c1df74f06e536b532695##
    <script>
        $(document).ready(function () {
            var form = $('#archive-form');

            form.submit(function (e) {
                $('#loading-modal').modal('show');
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('layouts.loading-modal', [
        'title' => 'Генерисање извештаја'
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
    <div class="container">
        <div class="d-flex justify-content-end mb-3">
            <form method="POST" action="<?php echo e(route('admin.reports.store')); ?>" target="_blank" id="generate-form">
                <?php echo csrf_field(); ?>
                <button class="btn btn-secondary" type="submit">Генериши</button>
            </form>
            <form method="POST" action="<?php echo e(route('admin.reports.archive')); ?>" onsubmit="$('#archive-modal').modal('toggle')" id="archive-form">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger ml-2"
                        type="button"
                        data-toggle="modal"
                        data-target="#archive-modal"
                >Архивирај</button>
                <?php echo $__env->make('layouts.password_confirm_modal', [
                        'name' => 'archive-modal',
                        'title' => 'Архивирај анкету',
                        'warning' => 'Архивирање анкете ће избрисати све одговоре и кодове из базе и сачувати извештај у .docx формату.',
                        'text' => 'Унеси своју лозинку како би архивирао анкету.',
                        'action' => 'Архивирај',
                        'cancel' => 'Одустани',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </form>
            <form method="POST" action="<?php echo e(route('admin.reports.reset')); ?>" id="reset-form" onsubmit="$('#reset-modal').modal('toggle')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger ml-2"
                        type="button"
                        data-toggle="modal"
                        data-target="#reset-modal"
                >Ресетуј</button>
                <?php echo $__env->make('layouts.password_confirm_modal', [
                        'name' => 'reset-modal',
                        'title' => 'Ресетуј анкету',
                        'warning' => 'Ресетовање анкете ће избрисати све одговоре и кодове и НЕЋЕ сачувати извештај.',
                        'text' => 'Унеси своју лозинку како би ресетовао анкету.',
                        'action' => 'Ресетуј',
                        'cancel' => 'Одустани',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </form>
        </div>

        <table class="table">
            <thead class="thead-dark">
                <th scope="col">
                    Извештај
                </th>
                <th scope="col">
                    Опције
                </th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reportName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th class="align-middle"><?php echo e($reportName); ?></th>
                        <td class="align-middle">
                            <a
                                    class="btn btn-secondary"
                                    href="<?php echo e(route('admin.reports.show', $reportName)); ?>"
                                    data-toggle="tooltip"
                                    data-placement="bottom"
                                    title="Преузми"
                            >
                                <i class="fa fa-download" style="color: #80ff1f"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akademij/public_html/anketa-pirot/resources/views/admin/reports/index.blade.php ENDPATH**/ ?>