<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header text-center h3 sticky-top"><?php echo e($question->text); ?> (<?php echo e($questionOrder); ?>/<?php echo e($questionCount); ?>)</div>

                        <form action="<?php echo e(route('survey.store', $question->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <?php if($question->isTeacher()): ?>
                                    <?php echo $__env->make('survey.partials.teacher_question_fields', [
                                        'subjects' => $subjects,
                                        'answers'  => $answers,
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>

                                <?php if($question->isSubject() || $question->isSemesters()): ?>
                                    <?php echo $__env->make('survey.partials.subject_question_fields', [
                                        'subjects' => $subjects,
                                        'answers'  => $answers,
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>

                                <?php if($question->isOther()): ?>
                                        <?php echo $__env->make('survey.partials.other_question_fields', [
                                            'answers' => $answers
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>

                                <?php if($question->isTextAnswer()): ?>
                                <div class="form-text form-text-inline w-100">
                                    <input class="form-text-input form-control-lg w-100" type="text" max-length="255" name="textanswer" id="textanswer" value="">
                                </div>
                                <?php endif; ?>
                            </div>

                        <div class="card-footer">
                            <?php if(!$isFirst): ?>
                            <a class="btn btn-primary" href="<?php echo e(route('survey.show', $previousQuestion->id)); ?>">
                                Назад
                            </a>
                            <?php endif; ?>
                            <button class="btn btn-success" type="submit">
                                <?php if($isLast): ?>
                                    Заврши
                                <?php else: ?>
                                    Даље
                                <?php endif; ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akademij/public_html/anketaon/resources/views/survey/show.blade.php ENDPATH**/ ?>