@extends('layouts.admin')

@section('title', "Измени {$subject->name}")

@section('content')
    <div class="container">
            <div class="h1 text-center">
                {{ $subject->name }}
            </div>

            <div class="row justify-content-center">
                <div class="col-md-8 mt-5">
                    <form method="POST" action="{{ route('admin.subjects.update', $subject->id) }}">
                        @csrf
                        @method('PATCH')

                        @include('admin.subjects.partials.fields')

                        <div class="d-flex justify-content-center">
                            @include('admin.partials.form_actions', [
                            'submitCta' => 'Сачувај',
                            'cancelUrl' => route('admin.departments.show', $subject->department_id),
                            'cancelCta' => 'Откажи',
                            ])
                        </div>
                    </form>
                </div>
            </div>
    </div>
@endsection
