<?php $__env->startSection('title', 'Izveštaji'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="d-flex justify-content-end mb-3">
            <form method="POST" action="<?php echo e(route('admin.reports.store')); ?>">
                <?php echo csrf_field(); ?>
                <button class="btn btn-secondary" type="submit">Generiši</button>
            </form>
            <form method="POST" accept-charset="<?php echo e(route('admin.reports.destroy')); ?>" onsubmit="$('#archive-modal').modal('toggle')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger ml-2"
                        type="button"
                        data-toggle="modal"
                        data-target="#archive-modal"
                >Arhiviraj</button>
                <?php echo $__env->make('layouts.password_confirm_modal', [
                        'name' => 'archive-modal',
                        'title' => 'Arhiviraj anketu',
                        'warning' => 'Arhiviranje ankete će izbrisati sve odgovore i kodove iz baze i sačuvati izveštaj u .docx formatu',
                        'text' => 'Unesi svoju lozinku kako bi arhivirao anketu',
                        'action' => 'Arhiviraj',
                        'cancel' => 'Odustani',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </form>
        </div>

        <table class="table">
            <thead class="thead-dark">
                <th scope="col">
                    Izveštaj
                </th>
                <th scope="col">
                    Opcije
                </th>
            </thead>
            <tbody>
                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reportName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th class="align-middle"><?php echo e($reportName); ?></th>
                        <td class="align-middle">
                            <a
                                    class="btn btn-secondary"
                                    href="<?php echo e(route('admin.reports.show', $reportName)); ?>"
                                    data-toggle="tooltip"
                                    data-placement="bottom"
                                    title="Preuzmi"
                            >
                                <i class="fa fa-download" style="color: #80ff1f"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/misakovic1/Projekti/anketa/resources/views/admin/reports/index.blade.php ENDPATH**/ ?>