<?php $__env->startSection('title', 'Питање'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="col-md-10">
            <div class="d-flex justify-content-start">
                На сва питања се одговор даје у виду оцене од 1 до 5.
            </div>
            <div class="d-flex justify-content-end mb-3">
                <a class="btn btn-secondary mr-1" href="<?php echo e(route('admin.questions.create')); ?>">Додај питање</a>
            </div>

            <div class="mt-4">
                <ul class="nav nav-tabs" id="questions" role="tablist">

                    <li class="nav-item">
                        <a
                                class="nav-link active"
                                id="teacher-tab"
                                data-toggle="tab"
                                href="#teacher-questions"
                                role="tab"
                                aria-controls="teacher-questions"
                                aria-selected="true"
                        >Питања о професорима</a>
                    </li>

                    <li class="nav-item">
                        <a
                                class="nav-link"
                                id="subject-tab"
                                data-toggle="tab"
                                href="#subject-questions"
                                role="tab"
                                aria-controls="subject-questions"
                        >Питања о предметима</a>
                    </li>

                    <li class="nav-item">
                        <a
                                class="nav-link"
                                id="other-tab"
                                data-toggle="tab"
                                href="#other-questions"
                                role="tab"
                                aria-controls="other-questions"
                        >Питања о школи</a>
                    </li>
                </ul>

                <div class="tab-content mt-4">
                    <div class="tab-pane active" id="teacher-questions" role="tabpanel" aria-labelledby="teacher-tab">
                        <table class="table">
                            <thead class="thead-dark">
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $questions->get('teacher') ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th class="align-middle" scope="row"><?php echo e($question->text); ?></th>
                                    <td>
                                        <div class="row">
                                            <div class="mr-1">
                                                <?php echo $__env->make('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                            <?php echo $__env->make('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="tab-pane" id="subject-questions" role="tabpanel" aria-labelledby="subject-tab">
                        <table class="table">
                            <thead class="thead-dark">
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $questions->get('subject') ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th class="align-middle" scope="row"><?php echo e($question->text); ?></th>
                                    <td>
                                        <div class="row">
                                            <div class="mr-1">
                                                <?php echo $__env->make('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                            <?php echo $__env->make('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="tab-pane" id="other-questions" role="tabpanel" aria-labelledby="other-tab">
                        <table class="table">
                            <thead class="thead-dark">
                            <th scope="col">
                                Питање
                            </th>
                            <th scope="col">
                                Опције
                            </th>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $questions->get('other') ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th class="align-middle" scope="row"><?php echo e($question->text); ?></th>
                                    <td>
                                        <div class="row">
                                            <div class="mr-1">
                                                <?php echo $__env->make('admin.partials.buttons.delete', [
                                                    'url' => route('admin.questions.destroy', $question->id),
                                                    'modalId' => "delete-{$question->id}-modal",
                                                    'modalTitle' => 'Брисање питања',
                                                    'modalText' => "Потврди брисање питања \"{$question->text}\"",
                                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                            <?php echo $__env->make('admin.partials.buttons.edit', ['url' => route('admin.questions.edit', $question->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akademij/public_html/anketa-pirot/resources/views/admin/questions/index.blade.php ENDPATH**/ ?>