<?php $__env->startSection('title', $department->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <?php echo $__env->make('admin.departments.navigation', ['departments' => $departments, 'activeDepartment' => $department->id, 'routeLink' => 'admin.departments.show'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-9">
                <div class="d-flex justify-content-end mb-3">
                    <a class="btn btn-secondary mr-1" href="<?php echo e(route('admin.departments.subjects.create', $department->id)); ?>">Додај предмет</a>
                    <button class="btn btn-secondary" id="upload-excel-button" type="button">Учитај Ексел</button>
                    <form method="POST" action="<?php echo e(route('admin.departments.import', $department->id)); ?>" id="upload-excel-form" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="file" id="upload-excel-input" name="excel" hidden>
                    </form>
                    <a class="btn btn-secondary ml-1" href="<?php echo e(route('admin.departments.edit', $department->id)); ?>">Измени смер</a>
                </div>
                <div class="d-flex justify-content-end mb-3">
                    <a href="<?php echo e(asset('dwnl/Excel_primer.xlsx')); ?>"><i style="color: green" class="fa fa-file-excel-o"></i>Пример Ексела</a>
                </div>
                <ul class="nav nav-tabs" id="semesters" role="tablist">
                    <?php $__currentLoopData = $semesters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $subjects): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a
                                    class="nav-link <?php if($loop->first): ?> active <?php endif; ?> "
                                    id="<?php echo e($semester); ?>-tab"
                                    data-toggle="tab"
                                    href="#semester-<?php echo e($semester); ?>"
                                    role="tab"
                                    aria-controls="semester-<?php echo e($semester); ?>"
                                    <?php if($loop->first): ?>
                                        aria-selected="true"
                                    <?php endif; ?>
                            ><?php echo e($semester); ?>. семестар</a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>

                <div class="tab-content mt-4">
                    <?php $__currentLoopData = $semesters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semester => $subjects): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane <?php if($loop->first): ?> active <?php endif; ?>" id="semester-<?php echo e($semester); ?>" role="tabpanel" aria-labelledby="<?php echo e($semester); ?>-tab">
                            <table class="table">
                                <thead class="thead-dark">
                                    <th scope="col">
                                        Предмет
                                    </th>
                                    <th scope="col">
                                        Професор/и
                                    </th>
                                    <th scope="col">
                                        Асистент
                                    </th>
                                    <th scope="col">
                                        Семестар
                                    </th>
                                    <th scope="col">
                                        Опције
                                    </th>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $subjects->sortBy('name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th class="align-middle" scope="row"><?php echo e($subject->name); ?></th>
                                            <td class="align-middle">
                                            <?php if($subject->teacher_alt_id != null): ?>
                                                <?php echo e($subject->teacher->name . ', ' . optional($subject->teacher_alt)->name); ?>

                                            <?php else: ?>
                                                <?php echo e($subject->teacher->name); ?></td>
                                            <?php endif; ?>
                                            <td class="align-middle"><?php echo e(optional($subject->assistant)->name); ?></td>
                                            <td class="align-middle"><?php echo e($subject->semester); ?></td>
                                            <td>
                                                <div class="row">
                                                    <div class="mr-1">
                                                        <?php echo $__env->make('admin.partials.buttons.delete', [
                                                            'url' => route('admin.subjects.destroy', $subject->id),
                                                            'modalId' => "delete-{$subject->id}",
                                                            'modalTitle' => "Избриши {$subject->name}",
                                                            'modalText' => "Потврди брисање {$subject->name}",
                                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    </div>
                                                    <?php echo $__env->make('admin.partials.buttons.edit', ['url' => route('admin.subjects.edit', $subject->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    ##parent-placeholder-16728d18790deb58b3b8c1df74f06e536b532695##
    <script>
        $(document).ready(function () {
            $('#upload-excel-button').on('click', function () {
                $('#upload-excel-input').trigger('click');
            });
            $('#upload-excel-input').on('change', function () {
                $('#upload-excel-form').submit();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akademij/public_html/anketaov/resources/views/admin/departments/show.blade.php ENDPATH**/ ?>