<?php

namespace App\Services\Calculators;

use App\Models\Question;

class SemesterAnswers extends Calculator
{
    public function calculate(AnswerSet $answerSet)
    {
        $questions = $answerSet->getSemestersQuestions();
        $answers = $answerSet->getSemestersAnswers();

        return $questions->keyBy('id')->map(function (Question $question) use ($answers) {
            return $this->formatDecimal($answers->where('question_id', $question->id)->average->mark);
        });
    }
}