<?php

namespace App\Services\Calculators\Department;

use App\Services\Calculators\AnswerSet;
use Illuminate\Support\Collection;

class SubjectByStandardAnswers extends DepartmentCalculatorByStandard
{
    public function calculate(AnswerSet $answerSet, int $standard)
    {
        $questionIds = $answerSet->getSubjectByStandardQuestions($standard)->pluck('id');
        $answers = $this->getAnswersForDepartment($answerSet)->whereIn('question_id', $questionIds)->groupBy->question_id;

        return $answers->map(function (Collection $questionAnswers) {
            return $this->formatDecimal($questionAnswers->average->mark);
        });

    }
}