@php
    /** @var \Illuminate\Support\Collection|\App\Models\Department[] $departments */
    /** @var \App\Models\Department $department */
    /** @var \Illuminate\Support\Collection|\App\Models\Code[] $departmentCodes */
@endphp
@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <img src="/images/logo_akademije_ng.png" class="w-50"/>
        </div>
        <br />
        <h1 class="text-center">
            Кодови за попуњавање анкете
        </h1>
        <h2 id="izabranStudProg" class="font-weight-bolder text-center"><?php 
        echo $department->name; ?></h2>
        <div class="row justify-content-center">
            <div id="studprogtabs" class="col-md-12 <?php if($department->id != null) echo 'd-none'; else echo ''; ?>">
                <legend class="text-center">
                    Изаберите студијски програм
                </legend>
                @include('admin.departments.navigation', [
                    'departments' => $departments,
                    'activeDepartment' => $department->id,
                    'routeLink' => 'codes.show',
                ])
            </div>
            
            @if($department->id == null && $departmentCodes->count() == 0)
            <script>activateTabs();</script>
            @elseif($department->id > 0 && $departmentCodes->count() > 0)
            <script>deactivateTabs();</script>
            <br />
            <a class="font-weight-bolder" href="#"  onclick="activateTabs()">Изаберите други студијски програм</a>
            <br />
            <legend class="text-center">
                Изаберите семестар који сте слушали.
            </legend>
            @elseif($department->id != null && $departmentCodes->count() == 0)
            <legend id="nemakodova" class="text-center">
                Нема више кодова за изабрани студијски програм. Уколико нисте попунили анкету обратите се на <a href="mailto:online@akademijanis.edu.rs"> online@akademijanis.edu.rs </a>
            </legend>
            <br />
                <a href="#" class="font-weight-bolder" style="font-size=2em;" onclick="activateTabs()">Изаберите други студијски програм</a>
            <br />
            @endif
            <script> 
            function activateTabs(){
                document.getElementById("izabranStudProg").classList.add("d-none");
                document.getElementById("studprogtabs").classList.remove("d-none");
                document.getElementById("nemakodova").classList.add("d-none");
            }
            function deactivateTabs(){
                document.getElementById("studprogtabs").classList.add("d-none");
                document.getElementById("izabranStudProg").classList.remove("d-none");
                changeCurrName();
            }
            </script>
            @if($department->id != null && $departmentCodes->count() != 0)
            <div class="col-md-12">
                <ul class="nav nav-tabs" id="semesters" role="tablist">
                    @foreach($departmentCodes as $semester => $semesterCodes)
                        <li class="nav-item">
                            <a
                                class="nav-link"
                                id="{{ $semester }}-tab"
                                data-toggle="tab"
                                href="#semester-{{ $semester }}"
                                role="tab"
                                aria-controls="semester-{{ $semester }}"
                                @if ($loop->first)
                                aria-selected="true"
                                @endif
                            >{{ $semester }}. семестар</a>
                        </li>
                    @endforeach
                </ul>
                
                <div class="tab-content mt-4">
                    @foreach($departmentCodes as $semester => $semesterCodes)
                        <div class="tab-pane" id="semester-{{ $semester }}" role="tabpanel" aria-labelledby="{{ $semester }}-tab">
                            <a class="btn btn-secondary float-right w-25 mb-3" href="{{ route('login') }}">Започни анкету</a>
                            <legend>
                                Копирајте један од кодова испод и кликните на започни анкету.
                            </legend>
                            <table class="table table-bordered content-center">
                                <thead class="thead-dark">
                                <th scope="col" colspan="3" class="text-center">
                                    Кодови
                                </th>
                                </thead>
                                <tbody>
                                @foreach ($semesterCodes->chunk(3) as $codesChunk)
                                    <tr>
                                        @foreach($codesChunk as $code)
                                            <td class="text-center">{{ $code->code }}</td>
                                        @endforeach
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
@endsection
