<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php $__env->startSection('title'); ?> <?php echo e(config('app.name')); ?> <?php echo $__env->yieldSection(); ?> - Админ | Анкета </title>

    <!-- Scripts -->
    <?php $__env->startSection('scripts'); ?>
        <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <?php echo $__env->yieldSection(); ?>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
<div id="app">
    <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('admin.departments.index')); ?>">
                <img src="/images/logo_akademije_ng.png" style="width:250px;" />
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <!-- Left Side Of Navbar -->
                <ul class="navbar-nav mr-auto">

                </ul>

                <!-- Right Side Of Navbar -->
                <?php if(auth()->guard('admin')->check()): ?>
                    <ul class="nav nav-pills">
                        <li class="nav-item">
                            <a class="nav-link <?php if($activeItem == 'teachers'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.teachers.index')); ?>">Професори</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if($activeItem == 'questions'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.questions.index')); ?>">Питања</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if($activeItem == 'departments'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.departments.index')); ?>">Предмети</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if($activeItem == 'codes'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.departments.codes.first')); ?>">Кодови</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php if($activeItem == 'reports'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.reports.index')); ?>">Извештаји</a>
                        </li>
                        <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                            <i class="fa fa-user"></i> <span class="caret"></span>
                        </a>
                        <li class="nav-item dropdown">
                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="<?php echo e(route('admin.logout')); ?>"
                                   onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                    Одјави се
                                </a>

                                <form id="logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: none;">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <?php $__env->startSection('flash'); ?>
        <div class="container">
            <?php echo $__env->make('layouts.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    <?php echo $__env->yieldSection(); ?>

    <main class="py-4">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
</div>
</body>
</html>
<?php /**PATH /home/akademij/public_html/anketaon/resources/views/layouts/admin.blade.php ENDPATH**/ ?>