<?php $__env->startSection('title', 'Profesori'); ?>

<?php $__env->startSection('scripts'); ?>
    ##parent-placeholder-16728d18790deb58b3b8c1df74f06e536b532695##

    <script>
        $(document).ready(function(){
            $("#search-input").on("keyup", function() {
                var value = $(this).val().toLowerCase();
                $("#teachers-table tr").not('thead tr').filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="col-md-10">
            <div class="d-flex justify-content-end mb-2">
                <a class="btn btn-secondary" href="<?php echo e(route('admin.teachers.create')); ?>">Dodaj profesora</a>
            </div>

            <div class="d-flex justify-content-end mb-2">
                <input class="form-control" id="search-input" type="text" placeholder="Pretraži profesore">
            </div>

            <table class="table" id="teachers-table">
                <thead class="thead-dark">
                <th scope="col">
                    Profesor
                </th>
                <th scope="col">
                    Opcije
                </th>
                </thead>
                <tbody>
                <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th class="align-middle" scope="row">
                                <a href="<?php echo e(route('admin.teachers.show', $teacher->id)); ?>">
                                    <?php echo e($teacher->name); ?>

                                </a>
                            </th>
                            <td>
                                <div class="row">
                                    <div class="mr-1">
                                        <?php echo $__env->make('admin.partials.buttons.delete', [
                                            'url' => route('admin.teachers.destroy', $teacher->id),
                                            'modalId' => "delete-{$teacher->id}",
                                            'modalTitle' => "Izbriši {$teacher->name}",
                                            'modalText' => "Potvrdi brisanje profesora {$teacher->name}",
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <?php echo $__env->make('admin.partials.buttons.edit', ['url' => route('admin.teachers.edit', $teacher->id)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </td>
                        </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/misakovic1/Projekti/anketa/resources/views/admin/teachers/index.blade.php ENDPATH**/ ?>