/* global jQuery:false, elementorFrontend:false */

(function() {

	"use strict";

	var trx_addons_once_resize = false;

	var $window         = jQuery( window ),
		$document       = jQuery( document ),
		$body           = jQuery( 'body' );

	var $animated_items;

	update_jquery_links();

	// Update links and values after the new post added
	$document.on( 'action.got_ajax_response', update_jquery_links );
	$document.on( 'action.init_hidden_elements', update_jquery_links );
	function update_jquery_links() {
		$animated_items = jQuery('[class*="animated-item"]');
	}

	$document.on( 'action.init_hidden_elements', function(e, cont) {
		// Disable Elementor's lightbox on the .esgbox links
		//jQuery('.elementor-widget-container a.esgbox').attr('data-elementor-open-lightbox', 'no');
		cont.find('a.esgbox').attr('data-elementor-open-lightbox', 'no');

		// Disable Elementor's lightbox on every link to the large image
		cont.find('a[href$=".jpg"],a[href$=".jpeg"],a[href$=".png"],a[href$=".gif"]').attr('data-elementor-open-lightbox', 'no');

		// or Disable Elementor's lightbox only on the standard gallery
		//cont.find('.wp-block-gallery a[href$=".jpg"],.wp-block-gallery a[href$=".jpeg"],.wp-block-gallery a[href$=".png"],.wp-block-gallery a[href$=".gif"]').attr('data-elementor-open-lightbox', 'no');

		$animated_items = jQuery('[class*="animated-item"]');
	} );

	$window.on( 'elementor/frontend/init', function() {

		if ( typeof window.elementorFrontend !== 'undefined' && typeof window.elementorFrontend.hooks !== 'undefined' ) {

			// If Elementor is in the Editor's Preview mode
			if ( elementorFrontend.isEditMode() ) {

				// Init elements after creation
				elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $cont ) {

					// Add 'sc_layouts_item'
					if ( $body.hasClass('cpt_layouts-template') || $body.hasClass('cpt_layouts-template-default') || $body.hasClass('single-cpt_layouts') ) {
						$body.find('.elementor-element.elementor-widget').addClass('sc_layouts_item');
					}
					
					// Remove TOC if exists (rebuild on init_hidden_elements)
					jQuery('#toc_menu').remove();

					// Init hidden elements (widgets, shortcodes) when its added to the preview area
					$document.trigger('action.init_hidden_elements', [$cont]);

					// Trigger 'resize' actions after the element is added (inited)
					if ( $cont.parents('.elementor-section-stretched').length > 0 && !trx_addons_once_resize ) {
						trx_addons_once_resize = true;
						$document.trigger('action.resize_trx_addons', [$cont.parents('.elementor-section-stretched')]);
					} else {
						$document.trigger('action.resize_trx_addons', [$cont]);
					}
			
					trx_addons_elementor_animate_items();

				} );

				// First init - add wrap 'sc_layouts_item'
				if ( $body.hasClass('cpt_layouts-template') || $body.hasClass('cpt_layouts-template-default') || $body.hasClass('single-cpt_layouts') ) {
					jQuery('.elementor-element.elementor-widget').addClass('sc_layouts_item');
				}

				// First init - refresh theme-specific shapes
				jQuery('.elementor-shape').each(function() {
					var shape = jQuery(this).data('shape');
					if (shape!==undefined && shape.indexOf('trx_addons_')==0)
						trx_addons_load_shape(jQuery(this), shape);
				});

				// Load theme-specific shape to the container
				function trx_addons_load_shape(cont, shape) {
					if (cont.length > 0 && shape !== '') {
						cont.empty().attr( 'data-shape', shape );
						shape = TRX_ADDONS_STORAGE['shapes_url'] + shape.replace('trx_addons_', '') + '.svg';
						jQuery.get( shape, function( data ) {
							cont.append(data.childNodes[0]).attr('data-negative', 'false');
						} );
					}
				}

				// Shift elements down under fixed rows
				elementorFrontend.hooks.addFilter( 'frontend/handlers/menu_anchor/scroll_top_distance', function( scrollTop ) {
					return scrollTop - trx_addons_fixed_rows_height();
				} );

			// If Elementor is in Frontend
			} else {
				// Add page settings to the elementorFrontend object
				// in the frontend for non-Elementor pages (blog pages, categories, tags, etc.)
				if (typeof elementorFrontend.config !== 'undefined'
					&& typeof elementorFrontend.config.settings !== 'undefined'
					&& typeof elementorFrontend.config.settings.general === 'undefined'
				) {
					elementorFrontend.config.settings.general = {
						'elementor_stretched_section_container': TRX_ADDONS_STORAGE['elementor_stretched_section_container']
					};
				}
				// Call 'resize' handlers after Elementor inited
				// Use setTimeout to run our code after Elementor's stretch row code!
				setTimeout(function() {
					trx_addons_once_resize = true;
					$document.trigger('action.resize_trx_addons');
				}, 0);
			}
		}

	});

	// Open tabs on hover
	$document.on( 'action.init_hidden_elements', function(e, cont) {
		var tabs = cont.hasClass( 'elementor-widget-tabs' ) ? cont : jQuery( '.elementor-widget-tabs' );
		if ( tabs.hasClass('sc_tabs_open_on_hover_on') && ! tabs.hasClass('sc_tabs_open_on_hover_inited') ) {
			tabs
				.addClass( 'sc_tabs_open_on_hover_inited' )
				.on( 'mouseenter', '.elementor-tab-title:not(.elementor-active)', function(e) {
					jQuery(this).trigger('click');
				} );
		}
	} );

	// Init hidden elements on tab open
	$document.on( 'action.init_hidden_elements', function(e, cont) {
		var tabs = cont.hasClass( 'elementor-widget-tabs' ) ? cont : jQuery( '.elementor-widget-tabs' );
		if ( ! tabs.hasClass('sc_tabs_hidden_inited') ) {
			tabs
				.addClass( 'sc_tabs_hidden_inited' )
				.on( 'click', '.elementor-tab-title', function(e) {
					var $self = jQuery(this);
					var tab_content = tabs.find( '.elementor-tab-content[data-tab="' + $self.data('tab') + '"]' );
					setTimeout( function() {
						$document.trigger( 'action.init_hidden_elements', [tab_content] );
						$document.trigger( 'action.resize_trx_addons' );
					}, 0 );
				} );
		}
	} );

	// Open tabs on hover
	$document.on( 'action.init_hidden_elements', function(e, cont) {
		var tabs = cont.hasClass( 'elementor-widget-tabs' ) ? cont : jQuery( '.elementor-widget-tabs' );
		if ( tabs.hasClass('sc_tabs_open_on_hover_on') && ! tabs.hasClass('sc_tabs_open_on_hover_inited') ) {
			tabs
				.addClass( 'sc_tabs_open_on_hover_inited' )
				.on( 'mouseenter', '.elementor-tab-title:not(.elementor-active)', function(e) {
					jQuery(this).trigger('click');
				} );
		}
	} );


	// Move entrance animation parameters from the shortcode's wrapper to the items
	// to make sequental or random animation item by item
	$document.on( 'action.init_hidden_elements', function(e, cont) {
		trx_addons_elementor_animate_items();
		trx_addons_elementor_add_bg_text( cont );
	} );

	window.trx_addons_elementor_animate_items = function( force ) {
		jQuery('[class*="animation_type_"]:not(.animation_type_block)' + ( ! force ? ':not(.animated-separate)' : '' )).each( function() {
			var sc = jQuery(this),
				sc_name = sc.data('widget_type');
			if ( sc_name ) {
				sc_name = sc_name.split('.');
				sc_name = '.' + sc_name[0].replace('trx_', '') + '_item';
				if ( sc.find( sc_name ).length == 0 ) {
					sc_name = '.post_item';
					if ( sc.find( sc_name ).length == 0 ) {
						sc_name = '[class*="column-"]';
					}
				}
				sc_name += (sc_name ? ',.sc_item_subtitle,.sc_item_title,.sc_item_descr,.sc_item_posts_container + .sc_item_button,.sc_item_button.sc_title_button' : '');
			} else {
				sc_name = '[class*="column-"]';
			}
			var items = sc.find( sc_name );
			if ( items.length == 0 ) {
				sc.addClass( 'animation_type_block' );
				return;
			}
			var cid         = sc.data('model-cid'),
				params      = cid ? trx_addons_elementor_get_settings_by_cid( cid, ['_animation'] ) : sc.data('settings'),
				item_params = {},
				item_speed  = sc.hasClass( 'animated-slow' )
								? 'animated-slow'
								: ( sc.hasClass( 'animated-fast' )
									? 'animated-fast'
									: ''
									);
			if ( ! params ) {
				return;
			}
			for (var i in params) {
				if (i.substr(0, 10) == '_animation' || i.substr(0, 9) == 'animation') {
					item_params[i] = params[i];
					delete params[i];
				}
			}
			sc.removeClass('elementor-invisible animated '
					+ trx_addons_elementor_animate_items_animation( item_params ) 
					+ ( sc.data('last-animation') ? ' ' + sc.data('last-animation') : '' )
					)
				.addClass('animated-separate')
				.data( 'last-animation', trx_addons_elementor_animate_items_animation( item_params ) );
			if ( ! cid ) {
				sc.data('settings', params);
			}
			if ( item_speed != '' ) {
				sc.removeClass( item_speed );
			}
			sc.data( 'animation-settings', item_params );
			items.each( function(idx) {
				var item = jQuery(this);
				if ( item_speed != '' ) {
					item.addClass( item_speed );
				}
				item.addClass('elementor-invisible animated-item');
			} );

			if ( force ) {
				trx_addons_elementor_animate_items_scroll( force );
			}
		} );
	};

	function trx_addons_elementor_get_settings_by_cid( cid, keys ) {
		if ( typeof elementorFrontend != 'undefined' ) {
			var settings = elementorFrontend.config.elements.data[cid].attributes;
			if ( keys ) {
				var params = {};
				for ( var s in settings ) {
					for ( var i = 0; i < keys.length; i++ ) {
						if ( s.indexOf( keys[i] ) == 0 ) {
							params[s] = settings[s];
							break;
						}
					}
				}
				return params;
			}
			return settings;
		}
		return false;
	}

	// Add entrance animation for items (Elementor is not init its)
	$document.on('action.scroll_trx_addons', function() {
		trx_addons_elementor_animate_items_scroll();
	} );

	function trx_addons_elementor_animate_items_scroll( force ) {

		$animated_items.each(function(idx) {
			var item = $animated_items.eq(idx);
			if ( ! force && item.hasClass('animated') ) return;
			if ( item.offset().top + 50 < $window.scrollTop() + $window.height() ) {
				var sc = item.parents( '.animated-separate' );
				var item_params = sc.data('animation-settings'),
					item_delay = trx_addons_elementor_animate_items_delay(item_params, sc, idx),
					item_animation = trx_addons_elementor_animate_items_animation(item_params);
				if ( force ) {
					item
						.removeClass( item_animation + ( item.data('last-animation') ? ' ' + item.data('last-animation') : '' ) )
						.addClass('elementor-invisible')
						.data('last-animation', item_animation);
				} else {
					item.addClass('animated');
				}
				setTimeout( function() {
					item.removeClass('elementor-invisible').addClass(item_animation);
				}, item_delay );
			}
		});
	}

	function trx_addons_elementor_animate_items_delay( params, sc, idx ) {
		return sc.hasClass( 'animation_type_sequental' )
					? ( params && params._animation_delay ? params._animation_delay : 150 ) * idx
					: trx_addons_random( 0, params && params._animation_delay ? params._animation_delay : 1500 );
	}

	function trx_addons_elementor_animate_items_animation( params ) {
		var device = $body.data( 'elementor-device-mode' );
		if ( ! device || device == 'desktop' ) {
			device = '';
		} else {
			device = '_' + device;
		}
		return typeof params["_animation" + device] != 'undefined' ? params["_animation" + device] : params["_animation"];
	}


	// Add background text to the sections
	//----------------------------------------------------
	function trx_addons_elementor_add_bg_text( cont ) {
		if ( cont.hasClass('elementor-section') ) {
			cont.find('.trx_addons_bg_text').remove();
			trx_addons_elementor_add_bg_text_in_row( cont );
		} else {
			jQuery( '.trx_addons_has_bg_text:not(.trx_addons_has_bg_text_inited)' ).each( function() {
				trx_addons_elementor_add_bg_text_in_row( jQuery( this ) );
			} );
		}
	}

	// Add background text to the single section
	function trx_addons_elementor_add_bg_text_in_row( row ) {
		var data = row.data('bg-text'),
			cid = '';
		if ( ! data ) {
			cid  = row.data('model-cid');
			if ( cid ) {
				data = trx_addons_elementor_get_settings_by_cid( cid, ['bg_text'] );
			}
		}
		if ( ! data ) {
			return;
		}
		if ( data['bg_text'] ) {
			var row_cont = row.addClass('trx_addons_has_bg_text_inited');//.find('.elementor-container').eq(0);
			var chars = '', in_tag=false, ch;
			for ( var i=0; i < data['bg_text'].length; i++ ) {
				ch = data['bg_text'].substr(i,1);
				if ( ! in_tag ) {
					if ( ch == '<' ) {
						in_tag = true;
					} else {
						chars += '<span class="trx_addons_bg_text_char">' + ( ch == ' ' ? '&nbsp;' : ch ) + '</span>';
					}
				}
				if ( in_tag ) {
					chars += ch;
					if ( ch == '>' ) {
						in_tag = false;
					}
				}
			}
			var marquee_speed = typeof data['bg_text_marquee'] == 'object'
						? ( data['bg_text_marquee']['size']
							? data['bg_text_marquee']['size']
							: 0
							)
						: data['bg_text_marquee'],
				overlay = typeof data['bg_text_overlay'] == 'object'
						? data['bg_text_overlay']['url']
						: data['bg_text_overlay'];
			row_cont.prepend(
				'<div class="trx_addons_bg_text' + ( marquee_speed > 0 ? ' trx_addons_marquee_wrap' : '') + '">'
					+ '<div class="trx_addons_bg_text_inner'
									+ ' trx_addons_bg_text_effect_' + data['bg_text_effect']
									+ ( marquee_speed > 0 ? ' trx_addons_marquee_element' : '')
									+ ( cid == '' ? ' trx_addons_show_on_scroll' : ' trx_addons_showed_on_scroll trx_addons_in_preview_mode' )
									+ '"'
					+ '>'
						+ chars
					+ '</div>'
					+ ( overlay
						? '<div class="trx_addons_bg_text_overlay trx_addons_show_on_scroll"></div>'
						: ''
						)
				+ '</div>'
			);
			if ( marquee_speed > 0 && cid == '' ) {
				var marquee_wrap = row_cont.find('.trx_addons_marquee_wrap').eq(0),
					marquee_chars = marquee_wrap.find( '.trx_addons_bg_text_char' ).length,
					marquee_time = 20 * marquee_chars / 15;
				setTimeout( function() {
					trx_addons_elementor_marquee_bg_text( marquee_wrap, marquee_speed, marquee_time, true );
				}, marquee_chars * 100 + 800 );
			}
		}
	}

	function trx_addons_elementor_marquee_bg_text( marquee_wrap, marquee_speed, marquee_time, start ) {
		var elements = marquee_wrap.find('.trx_addons_marquee_element'),
			mw = elements.eq(0).outerWidth(),
			mx = 0,
			mpw = marquee_wrap.width();
		if ( elements.eq(0).hasClass( 'trx_addons_showed_on_scroll' ) ) {
			if ( start ) {
				for (var i=1; i < Math.ceil((mpw + mw) / mw); i++ ) {
					var element_clone = elements.eq(0).clone();
					elements.eq(0).after( element_clone );
				}
				elements = marquee_wrap.find('.trx_addons_marquee_element');
			}
			elements.each( function(idx) {
				TweenMax.to(
					elements.eq(idx),
					marquee_time - marquee_time * 0.8 * marquee_speed / 10,
					{
						x: -mw,
						y: 0,
						ease: Power0.easeNone,
						onComplete: function() {
							if ( idx == elements.length - 1 ) {
								elements.each( function(idx2) {
									TweenMax.to(
										elements.eq(idx2),
										0,
										{
											x: 0,
											y: 0,
											ease: Power0.easeNone
										}
									);
								});
								setTimeout( function() {
									trx_addons_elementor_marquee_bg_text( marquee_wrap, marquee_speed, marquee_time, false );
								}, 1);
							}
						}
					}
				);
			} );
		} else {
			setTimeout( function() {
				trx_addons_elementor_marquee_bg_text( marquee_wrap, marquee_speed, marquee_time, start );
			}, elements.eq(0).find( '.trx_addons_bg_text_char' ).length * 100 + 800 );
		}
	}

})();