<?php


namespace TenWebOptimizer;


/**
 * Class ExcludeJsFromDelay
 * @package TenWebOptimizer
 */
class ExcludeJsFromDelay
{
    public const EXCLUDE_LIST = array(
        'scripts' => array(
            'two_645cf3b5af449_3cc56afd5dcfa3a620c6f75c2d1befb8' => [
                'type' => 'script',
                'title' => 'Owl slider (js)',
                'regex_to_find' => '/owl-carousel/m',
                'scripts' => [
                     'jquery.min.js',
                     'jquery.js',
                     'owl.carousel.min.js',
                     'owl.carousel.js',
                     'owl.carousel2.thumbs.min.js',
                     'owl-carousel.min.js',
                ],
            ],
            'two_645cf3b5af45e_0826a5ad820ef3bf2bd5528da35a7b78' => [
                'type' => 'script',
                'title' => 'Slick slider (js)',
                'regex_to_find' => '/slick-slide|data-slick=|slick-/m',
                'scripts' => [
                     'jquery.min.js',
                     'jquery.js',
                     'slick.min.js',
                     'slick.js',
                ],
            ],
            'two_645cf3b5af461_5e39a03248f0c1c99a1594e2a5fcdf13' => [
                'type' => 'script',
                'title' => 'Google Ads (js)',
                'regex_to_find' => '/adsbygoogle = window.adsbygoogle/m',
                'scripts' => [
                     'pagead/js/adsbygoogle.js',
                     'adsbygoogle = window.adsbygoogle',
                ],
            ],
            'two_645cf3b5af462_46400b6683b8def660807bce443e2cb1' => [
                'title' => 'Amazon Ads (js)',
                'type' => 'script',
                'scripts' => [
                     'amazon-adsystem.com',
                ],
            ],
            'two_645cf3b5af464_6153132c18c325a08d2f281cdd8bf77e' => [
                'title' => 'Google AdSense (js)',
                'type' => 'script',
                'scripts' => [
                     'adsbygoogle',
                ],
            ],
            'two_645cf3b5af465_3a5e5a451da23c3d4ede9b043a71fa76' => [
                'title' => 'Google Analytics (js)',
                'type' => 'script',
                'scripts' => [
                     'google-analytics.com/analytics.js',
                     'ga\\( \'',
                     'ga\\(\'',
                ],
            ],
            'two_645cf3b5af466_d540ca317b9da75161d4c7433a3c31e3' => [
                'title' => 'Google Maps (js)',
                'type' => 'script',
                'scripts' => [
                     'maps.googleapis.com',
                     'maps.google.com',
                ],
            ],
            'two_645cf3b5af467_24d4bb848eb3dbfe92e7940811db9a75' => [
                'title' => 'Google Optimize (js)',
                'type' => 'script',
                'scripts' => [
                     'a,s,y,n,c,h,i,d,e',
                     'googleoptimize.com/optimize.js',
                     'async-hide',
                ],
            ],
            'two_645cf3b5af469_75b31653dd45ec546cab6c420fa32a42' => [
                'title' => 'Google Recaptcha (js)',
                'type' => 'script',
                'scripts' => [
                     'recaptcha',
                ],
            ],
            'two_645cf3b5af46a_b58dcb5c58c127842de54f92bee8d2c8' => [
                'title' => 'Google Tag Manager (js)',
                'type' => 'script',
                'scripts' => [
                     '/gtag/js',
                     'gtag\\(',
                     '/gtm.js',
                     'async-hide',
                ],
            ],
            'two_645cf3b5af46b_e45fc963d8e2a01ed7030d1f7e4dfa0d' => [
                'title' => 'HubSpot',
                'type' => 'script',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'js.hsforms.net',
                     'hbspt.forms.create',
                ],
            ],
            'two_645cf3b5af46c_8a98c86b49d93794705dd64bcdbbe3ab' => [
                'title' => 'Stripe (js)',
                'type' => 'script',
                'condition' => '',
                'scripts' => [
                     'js.stripe.com',
                ],
            ],
            'two_645cf3b5af46d_80d3a3ae46ff5b42fe6bbf0e99d13ba3' => [
                'title' => 'Typekit (js)',
                'type' => 'script',
                'scripts' => [
                     'typekit',
                ],
            ],
            'two_645cf3b5af46f_a1771e66dafb1debf8e0f55ad5cee0e8' => [
                'title' => 'Venatus Media (js)',
                'type' => 'script',
                'scripts' => [
                     '/ad-manager.min.js',
                     '__vm_add',
                ],
            ],
            'two_645cf3b5af470_383352e2d5640bab50cb439ceb9c48b0' => [
                'title' => 'Wistia (js)',
                'type' => 'script',
                'scripts' => [
                     'fast.wistia.com',
                ],
            ],
            'two_645cf3b5af471_da7f71c95688282f06f8fba42e14f877' => [
                'title' => 'Yandex Ads (js)',
                'type' => 'script',
                'condition' => '',
                'scripts' => [
                     'yandex.ru',
                     'window.yaContextCb',
                ],
            ],
        ),
        'plugins' => array(
            'two_645cf48d457d4_47d522d3cb4abfa9a623d0c21864356e' => [
                'type' => 'plugin',
                'title' => 'Elementor',
                'name' => 'elementor',
                'condition' => 'elementor/elementor.php',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     '/wp-includes/js/imagesloaded.min.js',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/happy-elementor-addons-pro/',
                     '/header-footer-elementor/inc/js/frontend.js',
                     'elementor-webpack-runtime-js',
                     'elementor-frontend-modules-js',
                     'elementor-frontend-js',
                     'elementor-frontend-js-before',
                     'swiper.min.js',
                     'pro-elements-handlers',
                     'pro-preloaded-elements-handlers',
                     'elementor-pro-frontend',
                     'ElementorProFrontendConfig',
                     'elementor-pro-webpack-runtime',
                     'elementor-frontend-modules',
                     'const lazyloadRunObserver',
                     'twbb-frontend-scripts',
                     'twbb-pro-features',
                ],
                'regex_to_find' => '/class="elementor-widget-container"/m',
            ],
            'two_645cf48d457db_9334f340c1ba58bf54ed37d3898dd99f' => [
                'type' => 'plugin',
                'title' => 'Elementor Pro',
                'name' => 'elementor-pro',
                'condition' => 'elementor-pro/elementor-pro.php',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     '/wp-includes/js/imagesloaded.min.js',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/happy-elementor-addons-pro/',
                     '/header-footer-elementor/inc/js/frontend.js',
                     'elementor-webpack-runtime-js',
                     'elementor-frontend-modules-js',
                     'elementor-frontend-js',
                     'elementor-frontend-js-before',
                     'swiper.min.js',
                     'pro-elements-handlers',
                     'pro-preloaded-elements-handlers',
                     'elementor-pro-frontend',
                     'ElementorProFrontendConfig',
                     'elementor-pro-webpack-runtime',
                     'elementor-frontend-modules',
                     'const lazyloadRunObserver',
                     'twbb-frontend-scripts',
                     'twbb-pro-features',
                ],
                'regex_to_find' => '/class="elementor-widget-container"/m',
            ],
            'two_645cf48d457dd_8e3dd77550d6ece1134867f5dc6c1fdb' => [
                'type' => 'plugin',
                'title' => 'Slider by 10Web',
                'name' => 'slider-wd',
                'condition' => 'slider-wd/slider-wd.php',
                'scripts' => [
                     '/jquery.min.js',
                     '/jquery.js',
                     '/slider-wd/js',
                     'wds_frontend-js-extra',
                     'wds_frontend-js-before',
                     'wds_params',
                     'wds_object',
                ],
                'regex_to_find' => '/id="wds_container/m',
            ],
            'two_645cf48d457de_35963ef4440c295121f3955c1d4c6e3f' => [
                'type' => 'plugin',
                'title' => 'Photo Gallery',
                'name' => 'photo-gallery',
                'condition' => 'photo-gallery/photo-gallery.php',
                'scripts' => [
                     '/jquery.min.js',
                     '/jquery.js',
                     '/photo-gallery/js',
                     '/photo-gallery-google-photos/js',
                     'bwg_frontend',
                     'bwg_objectsL10n',
                ],
                'regex_to_find' => '/id="bwg_container/m',
            ],
            'two_645cf48d457df_162cacf0d591b432412c89437dea28e0' => [
                'type' => 'plugin',
                'title' => 'AMP',
                'name' => 'amp',
                'condition' => 'amp/amp.php',
                'scripts' => [
                     'cdn.ampproject.org',
                ],
                'regex_to_find' => '/rel="amphtml"/m',
            ],
            'two_645cf48d457e0_92d14020733d85d20a6f51a46a38872d' => [
                'type' => 'plugin',
                'title' => 'Revolution Slider',
                'name' => 'revslider',
                'condition' => 'revslider/revslider.php',
                'two_slug' => 'exclude_rev',
                'scripts' => [
                     'jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     'jquery-migrate(.min)?.js',
                     '/revslider/public/assets/js/',
                     '/revslider-(.*)-addon/',
                     'setREVStartSize',
                     'rev_slider_',
                     'revslider_',
                     'window.RS_MODULES',
                ],
                'regex_to_find' => '/<\\/rs-module-wrap>|<\\/rs-slides>|<\\/rs-slide>|<\\/rs-layer>|<!-- END REVOLUTION SLIDER -->|id="rev_slider/m',
            ],
            'two_645cf48d457e1_40b1233f701cd0757ca4e61fe7e9a66c' => [
                'type' => 'plugin',
                'title' => 'Additional Variation Images Gallery for WooCommerce',
                'name' => 'woo-variation-gallery',
                'condition' => 'woo-variation-gallery/woo-variation-gallery.php',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/woo-variation-gallery/assets/js/slick.min.js',
                     '/woo-variation-gallery/assets/js/frontend.min.js',
                     '/wp-includes/js/underscore.min.js',
                     'variation_custom_fields',
                ],
            ],
            'two_645cf48d457e2_5f82e5d60baf61884d0a416cc9cadceb' => [
                'type' => 'plugin',
                'title' => 'Slider by Soliloquy',
                'name' => 'soliloquy-lite',
                'condition' => 'soliloquy-lite/soliloquy-lite.php',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'soliloquy-min.js',
                     'soliloquy_slider',
                ],
            ],
            'two_645cf48d457e3_d52dd6a55642dbe0b076ebbd9c416668' => [
                'title' => 'Advanced Ads',
                'type' => 'plugin',
                'condition' => 'advanced-ads/advanced-ads.php',
                'name' => 'advanced-ads',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/uploads/(.*).js',
                     'advanced_ads_ready',
                     'advadsCfpQueue',
                     'adsbygoogle',
                     'adservice.google',
                     '/advanced-ads(.*)',
                     'advads_items',
                     'advads_tracking_ads',
                ],
            ],
            'two_645cf48d457e4_e46862c0a528ed048924509b07c94cd0' => [
                'title' => 'All-in-one Compliance for GDPR / CCPA Cookie Consent',
                'type' => 'plugin',
                'condition' => 'iubenda-cookie-law-solution/iubenda_cookie_solution.php',
                'name' => 'iubenda-cookie-law-solution',
                'scripts' => [
                     'iubenda_cs.js',
                     'var _iub',
                ],
            ],
            'two_645cf48d457e5_eee27fc2fc75bb8e3426aa616b7dbd35' => [
                'title' => 'AMO Team Showcase',
                'type' => 'plugin',
                'condition' => 'amo-team-showcase/amo-team-showcase.php',
                'name' => 'amo-team-showcase',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/amo-team-showcase/public/js/wookmark.js',
                     '/amo-team-showcase/public/js/amo-team-showcase-public.js',
                     '/wp-includes/js/imagesloaded.min.js',
                     'amoTeamVars',
                ],
            ],
            'two_645cf48d457e6_d84326a794170289683b54922f768e4a' => [
                'title' => 'AnyWhere Elementor Pro',
                'type' => 'plugin',
                'condition' => 'anywhere-elementor-pro/anywhere-elementor-pro.php',
                'name' => 'anywhere-elementor-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/anywhere-elementor-pro/build/index.js',
                ],
            ],
            'two_645cf48d457e7_029f1ea3c935711773e66c7d63ae33d6' => [
                'title' => 'Astra - Pro Addon',
                'type' => 'plugin',
                'condition' => 'astra-addon/astra-addon.php',
                'name' => 'astra-addon',
                'scripts' => [
                     '/astra-addon/astra-addon-(.*).js',
                ],
            ],
            'two_645cf48d457e8_68e7b445c193c752ee63843a27f0a381' => [
                'title' => 'Beaver Builder',
                'type' => 'plugin',
                'condition' => 'beaver-builder-lite-version/fl-builder.php',
                'name' => 'beaver-builder-lite-version',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/uploads/bb-plugin/',
                     '/bb-plugin/js/yui3.min.js',
                     '/wp-includes/js/imagesloaded.min.js',
                     '/bb-plugin/js/fl-slideshow.min.js',
                ],
            ],
            'two_645cf48d457e9_93c48f50989fd8dd5fa09d062a2e8e26' => [
                'title' => 'Booked',
                'type' => 'plugin',
                'condition' => 'booked/booked.php',
                'name' => 'booked',
                'scripts' => [
                     '/booked/',
                     '/js/jquery/ui/datepicker.min.js',
                ],
            ],
            'two_645cf48d457ea_bd9091f84fe72178893254b8629f3455' => [
                'title' => 'Bookly',
                'type' => 'plugin',
                'condition' => 'bookly-responsive-appointment-booking-tool/main.php',
                'name' => 'bookly-responsive-appointment-booking-tool',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/bookly-responsive-appointment-booking-tool/frontend/',
                     'window.bookly',
                ],
            ],
            'two_645cf48d457eb_aa257cf2490fb94f54e7bd3c86711c3f' => [
                'title' => 'Borlabs Cookie',
                'type' => 'plugin',
                'condition' => 'borlabs-cookie/borlabs-cookie.php',
                'name' => 'borlabs-cookie',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'borlabsCookieConfig',
                     'borlabs-cookie.min.js',
                     'borlabsCookieContentBlocker',
                     'BorlabsCookieBox',
                ],
            ],
            'two_645cf48d457ec_75aebbc192a8b323a6fc9ee748c63009' => [
                'title' => 'Brizy',
                'type' => 'plugin',
                'condition' => 'brizy/brizy.php',
                'name' => 'brizy',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/brizy/public/editor-build/(.*)-wp/editor/js/group-(.*).js',
                     '/brizy/public/editor-build/(.*)-wp/editor/js/preview.js',
                     'Brizy.emit',
                ],
            ],
            'two_645cf48d457ed_7bb8758f440fa7cb8c86288f1898ea83' => [
                'title' => 'Carousel Upsells and Related Product for WooCommerce',
                'type' => 'plugin',
                'condition' => 'carousel-upsells-and-related-product-for-woocommerce/ffxf-woo-glide-related-and-upsells.php',
                'name' => 'carousel-upsells-and-related-product-for-woocommerce',
                'scripts' => [
                     '/carousel-upsells-and-related-product-for-woocommerce/assets/js/glide.min.js',
                     'carusel_poduct_related',
                ],
            ],
            'two_645cf48d457ee_662be198e49fd454c874abdefba56f89' => [
                'title' => 'clickskeks.at Cookiebanner',
                'type' => 'plugin',
                'condition' => 'clickskeks/index.php',
                'name' => 'clickskeks',
                'scripts' => [
                     'clickskeks',
                ],
            ],
            'two_645cf48d457ef_28a25fabe228d9f0e78f8aa451d28b88' => [
                'title' => 'Complianz',
                'type' => 'plugin',
                'condition' => 'complianz-gpdr/complianz-gpdr.php',
                'name' => 'complianz-gpdr',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'complianz',
                ],
            ],
            'two_645cf48d457f0_eb005fa1c094f931b7f2368784280b59' => [
                'title' => 'Content Egg',
                'type' => 'plugin',
                'condition' => 'content-egg/content-egg.php',
                'name' => 'content-egg',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/content-egg/res/js/morrisjs/morris.min.js',
                     '/content-egg/res/js/morrisjs/raphael.min.js',
                     'Morris.Area',
                ],
            ],
            'two_645cf48d457f1_2c5f141d19aff27a6152794606d44793' => [
                'title' => 'Cookie Notice & Compliance for GDPR / CCPA',
                'condition' => 'cookie-notice/cookie-notice.php',
                'type' => 'plugin',
                'name' => 'cookie-notice',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/cookie-notice/',
                     'var cnArgs',
                ],
            ],
            'two_645cf48d457f2_1fa76aef96b1265785a4207648f94013' => [
                'title' => 'Cookiebot CMP',
                'type' => 'plugin',
                'condition' => 'cookiebot/cookiebot.php',
                'name' => 'cookiebot',
                'scripts' => [
                     'consent.cookiebot.com',
                ],
            ],
            'two_645cf48d457f3_dd33002accdf2a4c13158c66a09c002b' => [
                'title' => 'Coupon Referral Program',
                'type' => 'plugin',
                'condition' => 'coupon-referral-program/coupon-referral-program.php',
                'name' => 'coupon-referral-program',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/coupon-referral-program/',
                     '/wp-includes/js/jquery/ui/draggable.min.js',
                ],
            ],
            'two_645cf48d457f4_cd92cb505429e1421e0f56000f17dc59' => [
                'title' => 'Crisp - Live Chat and Chatbot',
                'type' => 'plugin',
                'condition' => 'crisp/crisp.php',
                'name' => 'crisp',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'CRISP_RUNTIME_CONFIG',
                     'l.js',
                ],
            ],
            'two_645cf48d457f5_94bf034e049dcdcfe8a005453e91a5ec' => [
                'title' => 'Custom Twitter Feeds pro',
                'type' => 'plugin',
                'condition' => 'custom-twitter-feeds-pro/custom-twitter-feed.php',
                'name' => 'custom-twitter-feeds-pro',
                'scripts' => [
                     '/custom-twitter-feeds-pro/js/ctf-scripts.min.js',
                ],
            ],
            'two_645cf48d457f6_9622851a6ca8c62285172503d5e9ce41' => [
                'title' => 'Customer Reviews for WooCommerce Plugin',
                'type' => 'plugin',
                'condition' => 'customer-reviews-woocommerce/ivole.php',
                'name' => 'customer-reviews-woocommerce',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/customer-reviews-woocommerce/js/colcade.js',
                ],
            ],
            'two_645cf48d457f7_5632f0c8d7bad0d92ede162b04812f28' => [
                'title' => 'Divi - Supreme',
                'condition' => 'supreme-modules-for-divi/supreme-modules-for-divi.php',
                'type' => 'plugin',
                'name' => 'supreme-modules-for-divi',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '.dipi_preloader_wrapper_outer',
                     '/Divi/js/scripts.min.js',
                     '/Divi/js/custom.unified.js',
                     '/js/magnific-popup.js',
                     'var DIVI',
                     '/supreme-modules-for-divi/',
                ],
            ],
            'two_645cf48d457f8_95b38920258c40acc7a8f39e0106dfde' => [
                'title' => 'Divi Den Pro',
                'type' => 'plugin',
                'condition' => 'ddpro/ddpro.php',
                'name' => 'ddpro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/ddpro/build/freddie/js/freddieScriptPageTransition.js',
                     '/ddpro/build/freddie/js/freddieScriptsHeaders.js',
                     '/ddpro/build/freddie/js/freddieScriptsContents.js',
                     '/ddpro/build/freddie/js/gsap/gsap.min.js',
                ],
            ],
            'two_645cf48d457f9_7b9701c8a4d2d7f14365a684c21c87be' => [
                'title' => 'Divi Mobile',
                'type' => 'plugin',
                'condition' => 'divi-mobile/divi-mobile.php',
                'name' => 'divi-mobile',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'divi-menu',
                     'dm_nav',
                ],
            ],
            'two_645cf48d457fa_36edd3df22f3d36f3937b47d8486295a' => [
                'title' => 'Divi Overlays',
                'condition' => 'divi-overlays/divi-overlays.php',
                'type' => 'plugin',
                'name' => 'divi-overlays',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '.dipi_preloader_wrapper_outer',
                     '/Divi/js/scripts.min.js',
                     '/Divi/js/custom.unified.js',
                     'var DIVI',
                     '/divi-overlays/',
                ],
            ],
            'two_645cf48d457fb_9b363d65c9c4e346abaa6c8480fd2fb7' => [
                'title' => 'Divi Pixel',
                'type' => 'plugin',
                'condition' => 'divi-pixel/divi-pixel.php',
                'name' => 'divi-pixel',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '.dipi_preloader_wrapper_outer',
                ],
            ],
            'two_645cf48d457fc_4bcffe14c1bcf9076a447b44368e9491' => [
                'title' => 'Divi Toolbox',
                'type' => 'plugin',
                'condition' => 'divi-toolbox/divi-toolbox.php',
                'name' => 'divi-toolbox',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'jQuery(\'.preloader\')',
                     '/divi-toolbox/assets/js/toolbox-scripts.js',
                ],
            ],
            'two_645cf48d457fd_fcd5129c7aad9d6244fb94ab2222b00c' => [
                'title' => 'Dynamic Pricing & Discounts Lite for WooCommerce',
                'condition' => 'woo-dynamic-pricing-discounts-lite/dynamic-pricing-discounts-lite-for-woocommerce.php',
                'type' => 'plugin',
                'name' => 'woo-dynamic-pricing-discounts-lite',
                'scripts' => [
                     '/woo-dynamic-pricing-discounts-lite/assets/OwlCarousel/dist/owl.carousel.min.js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                ],
            ],
            'two_645cf48d457fe_e1c2192bb6a78d461fb205a3b132a8ee' => [
                'title' => 'Dynamic Product Gallery for WooCommerce',
                'type' => 'plugin',
                'condition' => 'woocommerce-dynamic-gallery/wc_dynamic_gallery_woocommerce.php',
                'name' => 'woocommerce-dynamic-gallery',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/woocommerce-dynamic-gallery/',
                     'a3revWCDynamicGallery',
                ],
            ],
            'two_645cf48d457ff_177b3f106e282b9869843f0b36cc4efc' => [
                'title' => 'Dynamic.ooo - Dynamic Content for Elementor',
                'type' => 'plugin',
                'condition' => 'dynamic-content-for-elementor/dynamic-content-for-elementor.php',
                'name' => 'dynamic-content-for-elementor',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     '/wp-includes/js/imagesloaded.min.js',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/dynamic-content-for-elementor/assets/lib/expressionlanguage/expressionlanguage.min.js',
                     '/dynamic-content-for-elementor/assets/js/conditional-fields.min.js',
                     '/dynamic-content-for-elementor/assets/js/settings.min.js',
                     '/dynamic-content-for-elementor/assets/js/fix-background-loop.min.js',
                     '/wp-includes/js/dist/hooks.min.js',
                     '/wp-includes/js/dist/i18n.min.js',
                ],
            ],
            'two_645cf48d45800_d7881e0fd679a2f15f416aedf6e5f668' => [
                'title' => 'Easy Table of Contents',
                'type' => 'plugin',
                'condition' => 'easy-table-of-contents/easy-table-of-contents.php',
                'name' => 'easy-table-of-contents',
                'scripts' => [
                     '/easy-table-of-contents/assets/js/front.min.js',
                ],
            ],
            'two_645cf48d45801_3a38cc60e45f8688e7bc9c0882f5f1c3' => [
                'title' => 'Ecwid Ecommerce Shopping Cart',
                'type' => 'plugin',
                'condition' => 'ecwid-shopping-cart/ecwid-shopping-cart.php',
                'name' => 'ecwid-shopping-cart',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js ',
                     'app.ecwid.com/script.js ',
                     '/ecwid-shopping-cart/js/frontend.js ',
                     '/ecwid-shopping-cart/js/static-page.js ',
                     'ecwidParamswindow.ec ',
                     'jQuery.mobile ',
                     'xSearch ',
                     'xCategoriesV2 ',
                     'xProductBrowser ',
                     'Ecwid.init',
                ],
            ],
            'two_645cf48d45802_b5eb568bb6c6dd0ef8898f6b164970b9' => [
                'title' => 'Elementor Custom Skin',
                'type' => 'plugin',
                'condition' => 'ele-custom-skin/ele-custom-skin.php',
                'name' => 'ele-custom-skin',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/ele-custom-skin(.*)/assets/js/',
                ],
            ],
            'two_645cf48d45803_b513946859513474b2878625a1e5fdcf' => [
                'title' => 'Elementor Pro - SmartMenus',
                'type' => 'plugin',
                'condition' => 'elementor-pro/elementor-pro.php',
                'name' => 'elementor-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor-pro/assets/lib/smartmenus/jquery.smartmenus.min.js',
                     '/elementor-pro/assets/js/preloaded-elements-handlers.min.js',
                ],
            ],
            'two_645cf48d45804_10ef4a3661f2a4b0e2049323c51e9391' => [
                'title' => 'Elementor Pro - User Cache',
                'type' => 'plugin',
                'condition' => 'elementor-pro/elementor-pro.php',
                'name' => 'elementor-pro',
                'scripts' => [
                     '/wp-includes/js/underscore.min.js',
                     '/wp-includes/js/jquery/ui/core.min.js',
                     '/wp-includes/js/backbone.min.js',
                     'elementorAdminBarConfig',
                     'elementorCommonConfig',
                     'elementorWebCliConfig',
                     'elementorDevToolsConfig',
                ],
            ],
            'two_645cf48d45805_d3cb8e8aa9548d6dfd46d42e7839ee65' => [
                'title' => 'Essential Addons for Elementor',
                'type' => 'plugin',
                'condition' => 'essential-addons-for-elementor-lite/essential_adons_elementor.php',
                'name' => 'essential-addons-for-elementor-lite',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/essential-addons(-for)?-elementor(-lite)?/.*(.min)?.js',
                ],
            ],
            'two_645cf48d45806_bc8e18d568109ef438a4e4f7f5c7ac73' => [
                'title' => 'Essential Addons for Elementor Pro',
                'type' => 'plugin',
                'condition' => 'essential-addons-elementor/essential_adons_elementor.php',
                'name' => 'essential-addons-elementor',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/essential-addons(-for)?-elementor(-lite)?/.*(.min)?.js',
                ],
            ],
            'two_645cf48d45807_292f2b2a2e4ec59933d8cc2f464db513' => [
                'title' => 'Essential Grid',
                'type' => 'plugin',
                'condition' => 'essential-grid/essential-grid.php',
                'name' => 'essential-grid',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/essential-grid/',
                     'lightboxOptions',
                ],
            ],
            'two_645cf48d45808_3e60aee1112819f4409645e0fea17d4e' => [
                'title' => 'EventON Lite',
                'type' => 'plugin',
                'condition' => 'eventon-lite/eventon.php',
                'name' => 'eventon-lite',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/eventon-lite/assets/js/(.*)',
                ],
            ],
            'two_645cf48d45809_45bfde1deedf177d376ad9108a775aaf' => [
                'title' => 'FacetWP',
                'type' => 'plugin',
                'condition' => 'facetwp/index.php',
                'name' => 'facetwp',
                'scripts' => [
                     '/facetwp/assets/js/dist/front.min.js',
                     'window.FWP_',
                ],
            ],
            'two_645cf48d4580a_1ee16a83323b5c36e2170569fc46a2c7' => [
                'title' => 'FacetWP - Flyout menu',
                'type' => 'plugin',
                'condition' => 'facetwp-flyout/facetwp-flyout.php',
                'name' => 'facetwp-flyout',
                'scripts' => [
                     '/facetwp-flyout/assets/js/front.js',
                ],
            ],
            'two_645cf48d4580b_156b074a58d08ea140349fa7abd0b5ce' => [
                'title' => 'FiboSearch - Ajax Search for WooCommerce',
                'type' => 'plugin',
                'condition' => 'ajax-search-for-woocommerce/ajax-search-for-woocommerce.php',
                'name' => 'ajax-search-for-woocommerce',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.js',
                     '/wp-includes/js/jquery/jquery-migrate.js',
                     '/ajax-search-for-woocommerce-premium/assets/js/search.js',
                ],
            ],
            'two_645cf48d4580c_b2546d9f68e2c67abc15e30155434d59' => [
                'title' => 'FlexBlock',
                'type' => 'plugin',
                'condition' => 'flo-flex-builder/flo-flex-builder.php',
                'name' => 'flo-flex-builder',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/flo-flex-builder/dist/flex-public.min.js',
                     'flexDebug',
                ],
            ],
            'two_645cf48d4580d_336f0b41afedb9a32d202af7bb8d8146' => [
                'title' => 'Fluent Forms',
                'type' => 'plugin',
                'condition' => 'fluentform/fluentform.php',
                'name' => 'fluentform',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/fluentform/public/js/(.*).js',
                     '/fluentformpro/public/js/(.*).js',
                ],
            ],
            'two_645cf48d4580e_c30348f89e112c89975a549abe676e70' => [
                'title' => 'Flying Images',
                'type' => 'plugin',
                'condition' => 'nazy-load/flying-images.php',
                'name' => 'nazy-load',
                'scripts' => [
                     'flyingImages',
                ],
            ],
            'two_645cf48d4580f_0b30b47b24aaef6ab9fe570b7f696af2' => [
                'title' => 'FooGallery Premium',
                'type' => 'plugin',
                'condition' => 'foogallery-premium/foogallery.php',
                'name' => 'foogallery-premium',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/plugins/foobox-image-lightbox/free/js/foobox.free.min.js',
                     '/plugins/foogallery-premium/pro/extensions/default-templates/shared/js/foogallery.min.js',
                ],
            ],
            'two_645cf48d45810_498795c280f6a379fab0f664a2530dca' => [
                'title' => 'Formidable Forms',
                'type' => 'plugin',
                'condition' => 'formidable/formidable.php',
                'name' => 'formidable',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'frmSigs',
                     '/formidable-signature/js/frm.signature.min.js',
                ],
            ],
            'two_645cf48d45811_c3ac2bb2c1547535e81315432cbc0cad' => [
                'title' => 'Forminator',
                'type' => 'plugin',
                'condition' => 'forminator/forminator.php',
                'name' => 'forminator',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     'forminatorFront',
                     '/forminator/build/front/front.multi.min.js',
                     '/forminator/assets/js/library/jquery.validate.min.js',
                     '/forminator/assets/forminator-ui/js/forminator-form.min.js',
                     '/forminator/assets/forminator-ui/js/select2.full.min.js',
                     '/wp-includes/js/jquery/ui/datepicker.min.js',
                     '/wp-includes/js/dist/vendor/moment.min.js',
                ],
            ],
            'two_645cf48d45812_9f8289ae7313f30b186a9e915b5f0f6d' => [
                'title' => 'GDPR Cookie Compliance',
                'type' => 'plugin',
                'condition' => 'gdpr-cookie-compliance/moove-gdpr.php',
                'name' => 'gdpr-cookie-compliance',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/gdpr-cookie-compliance/dist/scripts/main.js',
                ],
            ],
            'two_645cf48d45813_24c9421fa533743bac5eefb1d52cd058' => [
                'title' => 'GDPR Cookie Consent',
                'type' => 'plugin',
                'condition' => 'webtoffee-gdpr-cookie-consent/cookie-law-info.php',
                'name' => 'webtoffee-gdpr-cookie-consent',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/public/js/cookie-law-info-public.js',
                     'Cli_Data',
                ],
            ],
            'two_645cf48d45814_506366a16a876b05d7dbe9dd0ef84bcd' => [
                'title' => 'Getwid - Gutenberg Blocks',
                'type' => 'plugin',
                'condition' => 'getwid/getwid.php',
                'name' => 'getwid',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/wp-includes/js/jquery/ui/tabs.min.js',
                     '/wp-includes/js/jquery/ui/core.min.js',
                ],
            ],
            'two_645cf48d45815_2e2f1bdd154095148736a19c5d50bad0' => [
                'title' => 'GoodLayers Core',
                'condition' => 'goodlayers-core/goodlayers-core.php',
                'type' => 'plugin',
                'name' => 'goodlayers-core',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js ',
                     '/goodlayers-core/plugins/script.js ',
                     '/goodlayers-core/include/js/page-builder.js',
                ],
            ],
            'two_645cf48d45816_6498c5bf8e31b45a883997f3da0295ed' => [
                'title' => 'Gravity Forms',
                'type' => 'plugin',
                'condition' => 'gravityforms/gravityforms.php',
                'name' => 'gravityforms',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/gravityforms/',
                     'gform',
                     'recaptcha',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/gravityforms/js/conditional_logic.min.js',
                ],
            ],
            'two_645cf48d45817_3a4b51726ccf538fdb6fd5468f64ef93' => [
                'title' => 'Green Forms',
                'type' => 'plugin',
                'condition' => 'green-forms/green-forms.php',
                'name' => 'green-forms',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     'leform.min.js',
                     'leform_customjs_handlers',
                     'leform_ajax_url',
                ],
            ],
            'two_645cf48d45818_3ccff0aaec4849f41ccb94fd00f213d9' => [
                'title' => 'GTM4WP',
                'type' => 'plugin',
                'condition' => 'duracelltomi-google-tag-manager/duracelltomi-google-tag-manager-for-wordpress.php',
                'name' => 'duracelltomi-google-tag-manager',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     'dataLayer',
                ],
            ],
            'two_645cf48d45819_2a99d2980f8aee2b514588c5f7cbd74e' => [
                'title' => 'GTranslate',
                'type' => 'plugin',
                'condition' => 'gtranslate/gtranslate.php',
                'name' => 'gtranslate',
                'scripts' => [
                     'translate.google.com',
                     'googleTranslateElementInit',
                ],
            ],
            'two_645cf48d4581a_40c676d7ef783608c7ef7025dc3c5f32' => [
                'title' => 'HBook',
                'type' => 'plugin',
                'condition' => 'hbook/hbook.php',
                'name' => 'hbook',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/hbook/',
                     'hb_booking_form_data',
                     'hb_max_date',
                ],
            ],
            'two_645cf48d4581b_860f93e8cc6777e0aa92082bcdd2cd30' => [
                'title' => 'HUSKY - Products Filter for WooCommerce',
                'type' => 'plugin',
                'condition' => 'woocommerce-products-filter/index.php',
                'name' => 'woocommerce-products-filter',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/woocommerce-products-filter/(.*)',
                     'woof',
                ],
            ],
            'two_645cf48d4581c_1efffa240b8958b01073d229dbd3f5ad' => [
                'title' => 'Instagram Feed Pro',
                'type' => 'plugin',
                'condition' => 'instagram-feed-pro/instagram-feed.php',
                'name' => 'instagram-feed-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/instagram-feed-pro/js/sbi-scripts.min.js',
                     'sb_instagram_js_options',
                ],
            ],
            'two_645cf48d4581d_39eff3aa50637d163472903b8439662e' => [
                'title' => 'Interactive Geo Maps',
                'type' => 'plugin',
                'condition' => 'interactive-geo-maps/interactive-geo-maps.php',
                'name' => 'interactive-geo-maps',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/interactive-geo-maps-premium/assets/public/map-service/app.min.js',
                     '/interactive-geo-maps/assets/public/map-service/app.js',
                     'iMapsData',
                     'cdn.amcharts.com/lib/',
                ],
            ],
            'two_645cf48d4581e_c117ada5ad6f2f5ce7e6f3e9c6e1fa63' => [
                'title' => 'Ivory Search',
                'condition' => 'add-search-to-menu/add-search-to-menu.php',
                'type' => 'plugin',
                'name' => 'add-search-to-menu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/add-search-to-menu/public/js/ivory-search.min.js',
                ],
            ],
            'two_645cf48d4581f_ce93f5a8f0b6c6fe8ec40b4a975715ee' => [
                'title' => 'JetBlocks',
                'type' => 'plugin',
                'condition' => 'jet-blocks/jet-blocks.php',
                'name' => 'jet-blocks',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/jet-blocks/assets/js/jet-blocks.min.js',
                ],
            ],
            'two_645cf48d45820_cfabbd105cd424f027ea2385af9d5fcd' => [
                'title' => 'JetBlog',
                'type' => 'plugin',
                'condition' => 'jet-blog/jet-blog.php',
                'name' => 'jet-blog',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor-pro/',
                     '/elementor/',
                     '/jet-blog/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     'hasJetBlogPlaylist',
                ],
            ],
            'two_645cf48d45821_126603f57f9f2618592279117d63bc0a' => [
                'title' => 'JetElements',
                'type' => 'plugin',
                'condition' => 'jet-elements/jet-elements.php',
                'name' => 'jet-elements',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/jet-elements/',
                     'hasJetBlogPlaylist',
                     'jetElements',
                     '/wp-includes/js/jquery/ui/',
                ],
            ],
            'two_645cf48d45822_91fd897c1e1cb6c13d4d2e4f10065815' => [
                'title' => 'JetMenu',
                'type' => 'plugin',
                'condition' => 'jet-menu/jet-menu.php',
                'name' => 'jet-menu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor-pro/',
                     '/elementor/',
                     '/jet-blog/assets/js/lib/slick/slick.min.js',
                     '/jet-elements/',
                     '/jet-menu/',
                     'elementorFrontendConfig',
                     'ElementorProFrontendConfig',
                     'hasJetBlogPlaylist',
                     'JetEngineSettings',
                     'jetMenuPublicSettings',
                     '/jet-reviews/assets/js/lib/vue.min.js',
                ],
            ],
            'two_645cf48d45823_7f5a191a649eeed7a3024d66136805e1' => [
                'title' => 'JetPopup',
                'type' => 'plugin',
                'condition' => 'jet-popup/jet-popup.php',
                'name' => 'jet-popup',
                'scripts' => [
                     '/jet-popup/assets/js/lib/anime-js/anime.min.js',
                     '/jet-popup/assets/js/jet-popup-frontend.js',
                     '/jet-woo-builder/',
                     'var jetPopupData',
                ],
            ],
            'two_645cf48d45824_fc4713f3eed008dafc59dae2fe5f583f' => [
                'title' => 'JetProductGallery',
                'type' => 'plugin',
                'condition' => 'jet-woo-product-gallery/jet-woo-product-gallery.php',
                'name' => 'jet-woo-product-gallery',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/jet-woo-product-gallery/assets/lib/swiper/swiper.min.js',
                     '/jet-woo-product-gallery/assets/js/jet-woo-product-gallery.min.js',
                ],
            ],
            'two_645cf48d45825_338123f2363242df6477f43df3b557af' => [
                'title' => 'JetReviews',
                'type' => 'plugin',
                'condition' => 'jet-reviews/jet-reviews.php',
                'name' => 'jet-reviews',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/jet-reviews/assets/js/jet-reviews-frontend.js',
                     '/jet-reviews/assets/js/lib/vue.min.js',
                     'jetReviewsWidget',
                ],
            ],
            'two_645cf48d45826_1cd9088b3472762037c9034d6407325f' => [
                'title' => 'JetSticky',
                'type' => 'plugin',
                'condition' => 'jetsticky-for-elementor/jetsticky-for-elementor.php',
                'name' => 'jetsticky-for-elementor',
                'scripts' => [
                     '/jetsticky-for-elementor/',
                ],
            ],
            'two_645cf48d45827_fa84914e1f26ca32ba9a08ef3f311e1d' => [
                'title' => 'JetTricks',
                'type' => 'plugin',
                'condition' => 'jet-tricks/jet-tricks.php',
                'name' => 'jet-tricks',
                'scripts' => [
                     '/jet-tricks/',
                ],
            ],
            'two_645cf48d45828_458015f139d47e3578f59aaeafcdd1b9' => [
                'title' => 'JetWoo Widgets For Elementor',
                'type' => 'plugin',
                'condition' => 'jet-woo-builder/jet-woo-builder.php',
                'name' => 'jet-woo-builder',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/jetwoo-widgets-for-elementor/assets/js/jet-woo-widgets.js',
                     '/jet-woo-builder/assets/js/jet-woo-builder.min.js',
                     '/jet-woo-builder/assets/js/frontend.min.js',
                     '/wp-includes/js/imagesloaded.min.js',
                ],
            ],
            'two_645cf48d45829_9c5167e9f5ce4607bf9828e9df3d74f1' => [
                'title' => 'JetWooBuilder',
                'type' => 'plugin',
                'condition' => 'jet-woo-builder/jet-woo-builder.php',
                'name' => 'jet-woo-builder',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/dist/hooks.min.js',
                     '/wp-includes/js/dist/i18n.min.js',
                     '/elementor-pro/',
                     '/elementor/',
                     'elementorFrontendConfig',
                     'ElementorProFrontendConfig',
                     'JetEngineSettings',
                     '/jet-woo-builder/',
                     '/jet-woo-builder-custom-quantity-selectors-main/assets/js/main.js',
                ],
            ],
            'two_645cf48d4582a_6fef65dd0c56f90475d29561ee18df4b' => [
                'title' => 'Layer Slider',
                'type' => 'plugin',
                'condition' => 'LayerSlider/layerslider.php',
                'name' => 'LayerSlider',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/LayerSlider/assets/static/layerslider/js/layerslider.utils.js',
                     '/LayerSlider/assets/static/layerslider/js/layerslider.kreaturamedia.jquery.js',
                     '/LayerSlider/assets/static/layerslider/js/layerslider.transitions.js',
                     'initLayerSlider',
                ],
            ],
            'two_645cf48d4582b_be7dad7db0a8077c97cf81692d0679a6' => [
                'title' => 'LoftLoader Pro',
                'type' => 'plugin',
                'condition' => 'loftloader-pro/loftloader-pro.php',
                'name' => 'loftloader-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'loftloader.min.js',
                ],
            ],
            'two_645cf48d4582c_49402b590af0a4d2b183639a7e6609fa' => [
                'title' => 'MailUp for WordPress',
                'type' => 'plugin',
                'condition' => 'mailup-email-and-newsletter-subscription-form/mailup.php',
                'name' => 'mailup-email-and-newsletter-subscription-form',
                'scripts' => [
                     '/mailup-email-and-newsletter-subscription-form/public/js/mailup-public.js',
                     'mailup-js-extra',
                ],
            ],
            'two_645cf48d4582d_57cb773ae7a82c8c8aae12fa8f8d7abd' => [
                'title' => 'Maintenance',
                'type' => 'plugin',
                'condition' => 'maintenance/maintenance.php',
                'name' => 'maintenance',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/maintenance/',
                ],
            ],
            'two_645cf48d4582e_55943a2cbb0d8b1331643698b2b79189' => [
                'title' => 'Maps Marker Pro',
                'type' => 'plugin',
                'condition' => 'maps-marker-pro/maps-marker-pro.php',
                'name' => 'maps-marker-pro',
                'scripts' => [
                     '/maps-marker-pro/js/mapsmarkerpro.js',
                     'var mapsMarkerPro',
                ],
            ],
            'two_645cf48d4582f_9ebe3a758fac1b074171651da0c3afaf' => [
                'title' => 'Master Popups',
                'condition' => 'master-popups/master-popups.php',
                'type' => 'plugin',
                'name' => 'master-popups',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/plugins/master-popups/assets/public/js/master-popups-libs.min.js',
                ],
            ],
            'two_645cf48d45830_28219e09137f7693d8c3445750ee4ab6' => [
                'title' => 'Master Slider',
                'type' => 'plugin',
                'condition' => 'master-slider/master-slider.php',
                'name' => 'master-slider',
                'scripts' => [
                     'masterslider',
                ],
            ],
            'two_645cf48d45831_f0a2eedeec161e74c9616ea58b489255' => [
                'title' => 'Max Mega Menu',
                'type' => 'plugin',
                'condition' => 'megamenu/megamenu.php',
                'name' => 'megamenu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/hoverIntent.min.js',
                     '/megamenu/js/maxmegamenu.js',
                     'var megamenu',
                ],
            ],
            'two_645cf48d45832_3a749995156e9dafa9d9c66f30b2fd09' => [
                'title' => 'Meta Slider',
                'type' => 'plugin',
                'condition' => 'ml-slider/ml-slider.php',
                'name' => 'ml-slider',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/ml-slider/',
                     'var metaslider',
                ],
            ],
            'two_645cf48d45833_453a9b3bfdab6ea719b2a34f5d2340c6' => [
                'title' => 'Monarch',
                'condition' => 'monarch/monarch.php',
                'type' => 'plugin',
                'name' => 'monarch',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'dt-place-monarch-icons',
                ],
            ],
            'two_645cf48d45834_3b162c58cb3be71f9a02eaad7cc4b508' => [
                'title' => 'Monster Insights',
                'type' => 'plugin',
                'condition' => 'google-analytics-for-wordpress/googleanalytics.php',
                'name' => 'google-analytics-for-wordpress',
                'scripts' => [
                     '__gtagTracker',
                     'monsterinsights_frontend',
                     '/google-analytics-for-wordpress/assets/js/frontend-gtag.min.js',
                ],
            ],
            'two_645cf48d45835_13e81f3811f1f0ef150cbfb6c9891fda' => [
                'title' => 'Motion.page',
                'type' => 'plugin',
                'condition' => 'motionpage/motionpage.php',
                'name' => 'motionpage',
                'scripts' => [
                     '/motionpage/core/includes/assets/js/(.*)',
                     '/motionpage/core/includes/assets/js/gsap/(.*)',
                     '/motionpage/assets/js/(.*)',
                     '/motionpage/assets/js/gsap/(.*)',
                ],
            ],
            'two_645cf48d45836_703b5034e8b7dfe12791da2dc46c49d0' => [
                'title' => 'Ninja Forms',
                'condition' => 'ninja-forms/ninja-forms.php',
                'type' => 'plugin',
                'name' => 'ninja-forms',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/underscore.min.js',
                     '/wp-includes/js/backbone.min.js',
                     '/ninja-forms/assets/js/min/front-end-deps.js',
                     '/ninja-forms/assets/js/min/front-end.js',
                     'nf-',
                ],
            ],
            'two_645cf48d45837_d34df9624982f0bad8a8da71693bfb79' => [
                'title' => 'Ninja Tables',
                'type' => 'plugin',
                'condition' => 'ninja-tables/ninja-tables.php',
                'name' => 'ninja-tables',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/ninja-tables(.*)/assets/',
                     '/ninja-tables(.*)/public/',
                     '/wp-includes/js/dist/vendor/moment.min.js',
                     'ninja_table_instance_',
                     'ninja_filter_',
                     'ninja_table_ready_init_table_id',
                ],
            ],
            'two_645cf48d45838_5aa5d22e905e7c20b761d71613a0fd15' => [
                'title' => 'NotificationX',
                'type' => 'plugin',
                'condition' => 'notificationx/notificationx.php',
                'name' => 'notificationx',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/notificationx/assets/public/js/(.*).js',
                     'notificationXArr',
                ],
            ],
            'two_645cf48d45839_016976f81b3fe66ba89cc163be067814' => [
                'title' => 'Ocean Elementor Widgets',
                'type' => 'plugin',
                'condition' => 'ocean-elementor-widgets/ocean-elementor-widgets.php',
                'name' => 'ocean-elementor-widgets',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/ocean-elementor-widgets/',
                ],
            ],
            'two_645cf48d4583a_de7bcbdb93293860b1a6275a4aee7718' => [
                'title' => 'One Click Accessibility',
                'type' => 'plugin',
                'condition' => 'pojo-accessibility/pojo-accessibility.php',
                'name' => 'pojo-accessibility',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/pojo-accessibility/assets/js/app.min.js',
                ],
            ],
            'two_645cf48d4583b_c13a141cf5dfc23645109ad01fd8d9a2' => [
                'title' => 'OoohBoi Steroids for Elementor',
                'type' => 'plugin',
                'condition' => 'ooohboi-steroids-for-elementor/ooohboi-steroids.php',
                'name' => 'ooohboi-steroids-for-elementor',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                     '/ooohboi-steroids-for-elementor/',
                ],
            ],
            'two_645cf48d4583c_39c1a259909e44be30dc39482452a3fb' => [
                'title' => 'Optimole',
                'type' => 'plugin',
                'condition' => 'optimole-wp/optimole-wp.php',
                'name' => 'optimole-wp',
                'scripts' => [
                     'optimoleData',
                ],
            ],
            'two_645cf48d4583d_3a6f249d97ff4e63d73c5bcba782d885' => [
                'title' => 'OSM - OpenStreetMap',
                'type' => 'plugin',
                'condition' => 'osm/osm.php',
                'name' => 'osm',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/osm/js/OL/',
                     '/osm/js/osm-v3-plugin-lib.js',
                     'vectorM',
                ],
            ],
            'two_645cf48d4583e_cad5636144459bc66090c038c2e520c9' => [
                'title' => 'OxyExtras',
                'type' => 'plugin',
                'condition' => 'oxyextras/plugin.php',
                'name' => 'oxyextras',
                'scripts' => [
                     'vime',
                     'vime.esm.js',
                ],
            ],
            'two_645cf48d4583f_6124d98749365e3db2c9e5b27ca04db6' => [
                'title' => 'Oxygen Builder',
                'type' => 'plugin',
                'condition' => 'oxygen/functions.php',
                'name' => 'oxygen',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/component-framework/vendor/aos/aos.js',
                     'AOS.init',
                     'oxygen_init_pro_menu',
                     'oxy-pro-menu-show-dropdown',
                     'oxy-shape-divider',
                     'oxygenVSBInitToggleJs',
                ],
            ],
            'two_645cf48d45840_1d19f4a3d3b09f86308bb880ecc5dd3d' => [
                'title' => 'PageLoader by Bonfire',
                'type' => 'plugin',
                'condition' => 'pageloader-by-bonfire/pageloader-by-bonfire.php',
                'name' => 'pageloader-by-bonfire',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/pageloader-by-bonfire/pageloader.js',
                     'bonfire-pageloader-overlay',
                ],
            ],
            'two_645cf48d45841_66893bc690e0227a5d5255e482dfa663' => [
                'title' => 'PDF Embedder',
                'type' => 'plugin',
                'condition' => 'pdf-embedder/pdf_embedder.php',
                'name' => 'pdf-embedder',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/pdf-embedder/js/(.*).js',
                ],
            ],
            'two_645cf48d45842_25df2fcec6170b0635f524773ff12dff' => [
                'title' => 'Perfect Brands for WooCommerce',
                'type' => 'plugin',
                'condition' => 'perfect-woocommerce-brands/perfect-woocommerce-brands.php',
                'name' => 'perfect-woocommerce-brands',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/perfect-woocommerce-brands/assets/lib/slick/slick.min.js',
                     '/perfect-woocommerce-brands/assets/js/functions-frontend.min.js',
                ],
            ],
            'two_645cf48d45843_3590b9439f37e3295dbab7c6cafb2965' => [
                'title' => 'Photonic',
                'type' => 'plugin',
                'condition' => 'photonic/photonic.php',
                'name' => 'photonic',
                'scripts' => [
                     '/photonic/include/js/front-end/module/photonic-baguettebox.min.js',
                ],
            ],
            'two_645cf48d45844_f4efac8820c3d55bc7716b2cdd68423f' => [
                'title' => 'Pixel Caffein',
                'type' => 'plugin',
                'condition' => 'pixel-caffeine/pixel-caffeine.php',
                'name' => 'pixel-caffeine',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/pixel-caffeine/build/frontend.js',
                     'aepc_pixel',
                ],
            ],
            'two_645cf48d45845_d89ce3e49dc3d590601c4d5d5df026c9' => [
                'title' => 'Pixel Manager for WooCommerce',
                'type' => 'plugin',
                'condition' => 'woocommerce-pixel-manager-pro/woocommerce-pixel-manager.php',
                'name' => 'woocommerce-pixel-manager-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/woocommerce-pixel-manager-pro/js/public/',
                     'wpm',
                ],
            ],
            'two_645cf48d45846_86fe56c37ef3765afabc173ea7684cde' => [
                'title' => 'Popup Builder',
                'type' => 'plugin',
                'condition' => 'popup-builder/popup-builder.php',
                'name' => 'popup-builder',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/popup-builder/public/js/(.*).js',
                     '/popupbuilder-exit-intent/public/javascript/ExitIntent.js',
                     'var sgpbPublicUrl',
                     'SGPB_POPUP_PARAMS',
                ],
            ],
            'two_645cf48d45847_f1fade7abf25b63d763c156ce541f504' => [
                'title' => 'Popup Maker',
                'type' => 'plugin',
                'condition' => 'popup-maker/popup-maker.php',
                'name' => 'popup-maker',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/jquery/ui/core.min.js',
                     '/pum/pum-site-scripts.js',
                     'pum',
                     '/plugins/popup-maker/assets/js/site.min.js',
                ],
            ],
            'two_645cf48d45848_3ddb3594a40746d8264f3b5836ed03b5' => [
                'title' => 'PowerPack Addons for Elementor',
                'type' => 'plugin',
                'condition' => 'powerpack-lite-for-elementor/powerpack-lite-elementor.php',
                'name' => 'powerpack-lite-for-elementor',
                'scripts' => [
                     '/powerpack-lite-for-elementor/assets/js/min/frontend.min.js',
                ],
            ],
            'two_645cf48d45849_d12c4e9deb9928405c442b2a2401e883' => [
                'title' => 'Preloader Plus',
                'type' => 'plugin',
                'condition' => 'preloader-plus/preloader-plus.php',
                'name' => 'preloader-plus',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/preloader-plus/(.*)',
                ],
            ],
            'two_645cf48d4584a_ebb6f8644a51e297d65d26ab69b0770d' => [
                'title' => 'Premium Addons for Elementor',
                'type' => 'plugin',
                'condition' => 'premium-addons-for-elementor/premium-addons-for-elementor.php',
                'name' => 'premium-addons-for-elementor',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/premium-addons-for-elementor/assets/frontend/min-js/premium-addons.min.js',
                     '/premium-addons-for-elementor/assets/frontend/min-js/isotope.min.js',
                     '/premium-addons-elementor/pa-frontend-(.*).min.js',
                     'window.scopes_array',
                     'lottie.min.js',
                ],
            ],
            'two_645cf48d4584b_358eff632163736d99ad8583a2e06abf' => [
                'title' => 'Presto Player',
                'type' => 'plugin',
                'condition' => 'presto-player/presto-player.php',
                'name' => 'presto-player',
                'scripts' => [
                     '/wp-includes/js/dist/vendor/regenerator-runtime.min.js',
                     '/presto-player/dist/components/web-components/web-components.esm.js',
                     '/presto-player/src/player/player-static.js',
                     'var player',
                     '/wp-includes/js/dist/api-fetch.min.js',
                     '/wp-includes/js/dist/hooks.min.js',
                     '/wp-includes/js/dist/i18n.min.js',
                ],
            ],
            'two_645cf48d4584c_a5b22c8c67c013bd06c07b45d124358b' => [
                'title' => 'Price Based on Country for WooCommerce Pro',
                'type' => 'plugin',
                'condition' => 'woocommerce-price-based-country-pro-addon/woocommerce-price-based-country-pro-addon.php',
                'name' => 'woocommerce-price-based-country-pro-addon',
                'scripts' => [
                     '/woocommerce-product-price-based-on-countries/assets/js/ajax-geolocation.min.js',
                     '/woocommerce-price-based-country-pro-addon/assets/js/currency-switcher.min.js',
                     'add-to-cart.min.js',
                     'cart-fragments.min.js',
                ],
            ],
            'two_645cf48d4584d_3368f0c61df53e005cc1382481e3b138' => [
                'title' => 'Prime Slider',
                'type' => 'plugin',
                'condition' => 'bdthemes-prime-slider-lite/bdthemes-prime-slider.php',
                'name' => 'bdthemes-prime-slider-lite',
                'scripts' => [
                     '/plugins/bdthemes-prime-slider-lite/assets/js/bdt-uikit.min.js',
                ],
            ],
            'two_645cf48d4584e_9a8b4e77719bca5f8abc94f3add76523' => [
                'title' => 'PRO Elements',
                'type' => 'plugin',
                'condition' => 'pro-elements/pro-elements.php',
                'name' => 'pro-elements',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/pro-elements/',
                ],
            ],
            'two_645cf48d4584f_eb3bac16ce0b10104556989311d71e56' => [
                'title' => 'Product Gallery Slider for WooCommerce',
                'type' => 'plugin',
                'condition' => 'twist/twist.php',
                'name' => 'twist',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/twist/assets/js/slick.min.js',
                     'wpgs-public-js-after',
                ],
            ],
            'two_645cf48d45850_c7b5edf40277c730833970325836356b' => [
                'title' => 'Rank Math SEO',
                'type' => 'plugin',
                'condition' => 'seo-by-rank-math/rank-math.php',
                'name' => 'seo-by-rank-math',
                'scripts' => [
                     'local_ga_js',
                ],
            ],
            'two_645cf48d45851_d972046bb86f9b92d57104245e5182c6' => [
                'title' => 'Retainful',
                'condition' => 'retainful-next-order-coupon-for-woocommerce/retainful-next-order-coupon-for-woocommerce.php',
                'type' => 'plugin',
                'name' => 'retainful-next-order-coupon-for-woocommerce',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/retainful-next-order-coupon-for-woocommerce/src/premium/assets/js/atc-popup.min.js',
                     '/retainful-next-order-coupon-for-woocommerce/src/premium/assets/js/exit-intent-popup.js',
                     'retainful.com',
                     'rnoc-add-to-cart-js-before',
                     'rnoc_redirect_coupon_popup',
                ],
            ],
            'two_645cf48d45852_004ff52ed85ddf476595cef5c74646b0' => [
                'title' => 'Sassy Social Share',
                'type' => 'plugin',
                'condition' => 'sassy-social-share/sassy-social-share.php',
                'name' => 'sassy-social-share',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/sassy-social-share/public/js/sassy-social-share-public.js',
                     'heateorSssLoadEvent',
                ],
            ],
            'two_645cf48d45853_232688c27e641f36d3f12998e414fe91' => [
                'title' => 'Scrollsequence',
                'condition' => 'scrollsequence-pro/scrollsequence-pro.php',
                'type' => 'plugin',
                'name' => 'scrollsequence-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/scrollsequence-pro/public/js/gsap__premium_only.js',
                     '/scrollsequence-pro/public/js/gsap-scrolltrigger__premium_only.js',
                     '/scrollsequence-pro/public/js/ssq-lib__premium_only.js',
                     'scrollsequence-input-script',
                ],
            ],
            'two_645cf48d45854_3d387afc142ddf2c0e715f1fe8c4c952' => [
                'title' => 'ShiftNav Pro - Responsive Mobile Menu',
                'type' => 'plugin',
                'condition' => 'shiftnav-pro/shiftnav.php',
                'name' => 'shiftnav-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/shiftnav-pro/assets/js/shiftnav(.*).js',
                ],
            ],
            'two_645cf48d45855_df7e968f4bd68a486ddf2f95911fb734' => [
                'title' => 'ShiftNav – Responsive Mobile Menu',
                'type' => 'plugin',
                'condition' => 'shiftnav-responsive-mobile-menu/shiftnav-responsive-mobile-menu.php',
                'name' => 'shiftnav-responsive-mobile-menu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/shiftnav-responsive-mobile-menu/',
                ],
            ],
            'two_645cf48d45856_98b6edafe4f4829f9765962ad56c9b6f' => [
                'title' => 'Short Pixel Adaptive Image',
                'type' => 'plugin',
                'condition' => 'shortpixel-adaptive-images/short-pixel-ai.php',
                'name' => 'shortpixel-adaptive-images',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/shortpixel-adaptive-images/assets/js/ai(.*).min.js',
                     'spai_settings',
                ],
            ],
            'two_645cf48d45857_93e0d5ee435ffe802747ef1761a4db79' => [
                'title' => 'Showcase IDX',
                'type' => 'plugin',
                'condition' => 'showcase-idx/showcaseidx.php',
                'name' => 'showcase-idx',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     'SIDX',
                     'search.showcaseidx.com/js/app-(.*).js',
                     'cdn.shortpixel.ai',
                ],
            ],
            'two_645cf48d45858_c0b2f8280e878f843b1f3df166e69d44' => [
                'title' => 'Side Cart WooCommerce',
                'type' => 'plugin',
                'condition' => 'side-cart-woocommerce/xoo-wsc-main.php',
                'name' => 'side-cart-woocommerce',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js',
                     '/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js',
                     '/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js',
                     '/plugins/woocommerce/assets/js/js-cookie/js.cookie.min.js',
                ],
            ],
            'two_645cf48d45859_82769bdf9836dc811b2515204949af39' => [
                'title' => 'Simple Banner',
                'type' => 'plugin',
                'condition' => 'simple-banner/simple-banner.php',
                'name' => 'simple-banner',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/simple-banner/',
                     'simpleBannerScriptParams',
                ],
            ],
            'two_645cf48d4585a_b1354aaa419d8c4589f4decf6398af95' => [
                'title' => 'Site Kit by Google',
                'type' => 'plugin',
                'condition' => 'google-site-kit/google-site-kit.php',
                'name' => 'google-site-kit',
                'scripts' => [
                     'google-analytics.com/analytics.js',
                     'ga\\( \'',
                     'ga\\(\'',
                     '/gtag/js',
                     'gtag\\(',
                     '/gtm.js',
                ],
            ],
            'two_645cf48d4585b_bcb62d0934a536675a3030fd814298e8' => [
                'title' => 'Slick Menu',
                'type' => 'plugin',
                'condition' => 'slick-menu/slick-menu.php',
                'name' => 'slick-menu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/slick-menu/',
                ],
            ],
            'two_645cf48d4585c_0b9d43123df0146c08d336acb550efd9' => [
                'title' => 'Smart Slider 3',
                'type' => 'plugin',
                'condition' => 'smart-slider-3/smart-slider-3.php',
                'name' => 'smart-slider-3',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/smart-slider-3/(.*).js',
                     '_N2',
                ],
            ],
            'two_645cf48d4585d_b0c1646c9fda4dbbd0e968b1b345cfa5' => [
                'title' => 'Smart Slider 3 Pro',
                'type' => 'plugin',
                'condition' => 'nextend-smart-slider3-pro/nextend-smart-slider3-pro.php',
                'name' => 'nextend-smart-slider3-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/SmartSlider3/(.*).js',
                     '_N2',
                ],
            ],
            'two_645cf48d4585e_97c66072e0a256bba29213581ba30bd9' => [
                'title' => 'Super Socializer',
                'condition' => 'super-socializer/super_socializer.php',
                'type' => 'plugin',
                'name' => 'super-socializer',
                'scripts' => [
                     'theChamp',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                ],
            ],
            'two_645cf48d45879_22ce94cb713408206b57cfcfc912f9db' => [
                'title' => 'Superfly Menu',
                'type' => 'plugin',
                'condition' => 'superfly-menu/superfly-menu.php',
                'name' => 'superfly-menu',
                'scripts' => [
                     '/superfly-menu/js/public.min.js ',
                     'window.SFM ',
                     'SFM_template',
                ],
            ],
            'two_645cf48d4587a_b782be58ad425d40747f81496acf9ac5' => [
                'title' => 'Tabby Responsive Tabs',
                'type' => 'plugin',
                'condition' => 'tabby-responsive-tabs/tabby-responsive-tabs.php',
                'name' => 'tabby-responsive-tabs',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/tabby-responsive-tabs/js/tabby.js',
                     'RESPONSIVEUI',
                ],
            ],
            'two_645cf48d4587b_479d04e2d82ec36e87a3850859bb62ba' => [
                'title' => 'The Plus Addons for Elementor',
                'type' => 'plugin',
                'condition' => 'the-plus-addons-for-elementor-page-builder/theplus_elementor_addon.php',
                'name' => 'the-plus-addons-for-elementor-page-builder',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/theplus-addons/(.*)',
                ],
            ],
            'two_645cf48d4587c_62f0c37037c992a02e7ad42ed6d3e10c' => [
                'title' => 'ThemeREX Addons',
                'type' => 'plugin',
                'condition' => 'trx_addons/trx_addons.php',
                'name' => 'trx_addons',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/trx_addons/js/__scripts-full.js',
                     '/trx_addons/components/cpt/layouts/shortcodes/menu/superfish.min.js',
                ],
            ],
            'two_645cf48d4587d_85e0b642798ad04e0be38bd5376cecd5' => [
                'title' => 'Thrive Architect',
                'type' => 'plugin',
                'condition' => 'thrive-visual-editor/thrive-visual-editor.php',
                'name' => 'thrive-visual-editor',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                ],
            ],
            'two_645cf48d4587e_e057fbf678f02f69ced40e8950e4622d' => [
                'title' => 'Thrive Comments',
                'condition' => 'thrive-comments/thrive-comments.php',
                'type' => 'plugin',
                'name' => 'thrive-comments',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/thrive-leads/',
                     'window.TL_Const',
                     'var ml=',
                     '/thrive-comments/assets/js/',
                     'ThriveComments',
                     '/wp-includes/js/underscore.min.js',
                     '/wp-includes/js/backbone.min.js',
                ],
            ],
            'two_645cf48d4587f_8c1f6b7ef9cb89b04d2ffec1bb4672e9' => [
                'title' => 'Thrive Leads',
                'type' => 'plugin',
                'condition' => 'thrive-leads/thrive-leads.php',
                'name' => 'thrive-leads',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/thrive-leads/',
                     'window.TL_Const',
                     'var ml=',
                     '/thrive-comments/assets/js/',
                     'ThriveComments',
                     '/wp-includes/js/underscore.min.js',
                     '/wp-includes/js/backbone.min.js',
                ],
            ],
            'two_645cf48d45880_3d7bc0277897c8269b000e82b5dd4f8e' => [
                'title' => 'Thrive Quiz Builder',
                'type' => 'plugin',
                'condition' => 'thrive-quiz-builder/thrive-quiz-builder.php',
                'name' => 'thrive-quiz-builder',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                ],
            ],
            'two_645cf48d45881_26d4f0054f38f60f2ddcba5d83d85a5d' => [
                'title' => 'Thrive Ultimatum',
                'type' => 'plugin',
                'condition' => 'thrive-ultimatum/thrive-ultimatum.php',
                'name' => 'thrive-ultimatum',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/thrive-ultimatum/',
                     'var TVE_Ult_',
                ],
            ],
            'two_645cf48d45882_d997fb50626636680094c8f90b56c62a' => [
                'title' => 'Tidio Chat',
                'type' => 'plugin',
                'condition' => 'tidio-live-chat/tidio-elements.php',
                'name' => 'tidio-live-chat',
                'scripts' => [
                     'document.tidioChatCode',
                ],
            ],
            'two_645cf48d45883_b8604c217fc5f86e6c05da7b409526b1' => [
                'title' => 'Toolset Blocks',
                'type' => 'plugin',
                'condition' => 'toolset-blocks/wp-views.php',
                'name' => 'toolset-blocks',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'toolsetCommonEs.fontToHead',
                     'toolsetCommonEs.styleToHead',
                     '/toolset-blocks/vendor/toolset/blocks/public/js/frontend.js',
                     '/toolset-blocks/vendor/toolset/common-es/public/toolset-common-es-frontend.js',
                     '/toolset-blocks/public/js/views-frontend.js',
                     '/wp-includes/js/underscore.min.js',
                ],
            ],
            'two_645cf48d45884_642b197507032b458ec9b91eaed4f945' => [
                'title' => 'Top Bar Pro',
                'type' => 'plugin',
                'condition' => 'topbar-pro/topbar_pro.php',
                'name' => 'topbar-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/plugins/topbar-pro/js/tpbr_front.min.js',
                     '/plugins/topbar-pro/js/jquery.cookie.js',
                ],
            ],
            'two_645cf48d45885_a50a12eee7caab7848728e0a59d96852' => [
                'title' => 'Twenty20 Image Before-After',
                'condition' => 'twenty20/ttwenty.php',
                'type' => 'plugin',
                'name' => 'twenty20',
                'scripts' => [
                     '/twenty20/assets/js/(.*).js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'twentytwenty-container',
                ],
            ],
            'two_645cf48d45886_31ced0f8849effad2045b92524518e00' => [
                'title' => 'UberMenu',
                'type' => 'plugin',
                'condition' => 'ubermenu/ubermenu.php',
                'name' => 'ubermenu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/ubermenu/assets/js/ubermenu.min.js',
                ],
            ],
            'two_645cf48d45887_2bb7eccbd7f27ccb4f355d98012aa229' => [
                'title' => 'Ultimate Addons for Elementor',
                'type' => 'plugin',
                'condition' => 'ultimate-elementor/ultimate-elementor.php',
                'name' => 'ultimate-elementor',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/ultimate-elementor/assets/lib/slick/slick.min.js',
                     '/ultimate-elementor/assets/min-js/uael-frontend.min.js',
                     '/ultimate-elementor/assets/lib/isotope/isotope.min.js',
                     '/ultimate-elementor/assets/lib/jquery-element-resize/jquery_resize.min.js',
                     '/ultimate-elementor/assets/lib/fancybox/jquery_fancybox.min.js',
                     '/ultimate-elementor/assets/lib/justifiedgallery/justifiedgallery.min.js',
                     '/elementor-pro/assets/js/frontend.min.js',
                     '/wp-includes/js/imagesloaded.min.js',
                     '/js_composer/assets/js/dist/js_composer_front.min.js',
                     '/elementor/assets/lib/swiper/swiper.min.js',
                     '/nasa-core/assets/js/min/jquery.slick.min.js',
                     '/elementor/',
                     '/elementor-pro/',
                     'ElementorProFrontendConfig',
                     'elementorFrontendConfig',
                ],
            ],
            'two_645cf48d45888_03dd61c3b8e91ff9ad2ca2f521d4731d' => [
                'title' => 'Ultimate Addons for WPBakery Page Builder',
                'type' => 'plugin',
                'condition' => 'Ultimate_VC_Addons/Ultimate_VC_Addons.php',
                'name' => 'Ultimate_VC_Addons',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/Ultimate_VC_Addons/assets/',
                ],
            ],
            'two_645cf48d45889_90b2d88b116a41fe40722a984a44d4a9' => [
                'title' => 'Ultimate Responsive Image Slider',
                'type' => 'plugin',
                'condition' => 'ultimate-responsive-image-slider/ultimate-responsive-image-slider.php',
                'name' => 'ultimate-responsive-image-slider',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'sliderPro',
                ],
            ],
            'two_645cf48d4588a_bf206196c9f0e97beac6ec6f96225740' => [
                'title' => 'Variation Swatches for WooCommerce',
                'type' => 'plugin',
                'condition' => 'woo-variation-swatches/woo-variation-swatches.php',
                'name' => 'woo-variation-swatches',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/jquery/ui/',
                     '/woo-variation-swatches/',
                     '/woo-variation-swatches-pro/',
                     'underscore.min.js',
                ],
            ],
            'two_645cf48d4588b_994aeb29e16a9850c4104f17432b3799' => [
                'title' => 'Web Accessibility By accessiBe',
                'type' => 'plugin',
                'condition' => 'accessibe/accessiebe.php',
                'name' => 'accessibe',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/accessibe/',
                     'acsbJS',
                ],
            ],
            'two_645cf48d4588c_8f75db0d150349427c89b9ab2b13ba99' => [
                'title' => 'WooCommerce - Cart Fragments',
                'condition' => 'woocommerce/woocommerce.php',
                'type' => 'plugin',
                'name' => 'woocommerce',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/woocommerce/assets/js/frontend/cart-fragments.min.js',
                     '/woocommerce/assets/js/js-cookie/js.cookie.min.js',
                ],
            ],
            'two_645cf48d4588d_89a88af326491c608298632f360b019e' => [
                'title' => 'WooCommerce - Product description',
                'condition' => 'woocommerce/woocommerce.php',
                'type' => 'plugin',
                'name' => 'woocommerce',
                'scripts' => [
                     '/plugins/woocommerce/assets/js/frontend/single-product.min.js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                ],
            ],
            'two_645cf48d4588e_dc4f749fd6da152c7dfe5c715c8b2c34' => [
                'title' => 'WooCommerce - Product Gallery',
                'condition' => 'woocommerce/woocommerce.php',
                'type' => 'plugin',
                'name' => 'woocommerce',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/woocommerce/(.*)/assets/js/zoom/jquery.zoom.min.js',
                     '/woocommerce/(.*)/assets/js/photoswipe/',
                     '/woocommerce/(.*)/assets/js/flexslider/jquery.flexslider.min.js',
                     '/woocommerce/(.*)/assets/js/frontend/single-product.min.js',
                     'wc_single_product_params',
                ],
            ],
            'two_645cf48d4588f_9dfe34b6ee9a111482934c31d40e06f8' => [
                'title' => 'WooCommerce - Select2 library',
                'condition' => 'woocommerce/woocommerce.php',
                'type' => 'plugin',
                'name' => 'woocommerce',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/woocommerce/assets/js/select2/select2(.*).js',
                ],
            ],
            'two_645cf48d45890_6de7eac3b4716f175eceaf68bfb5ea83' => [
                'title' => 'WooCommerce Attribute Swatches',
                'type' => 'plugin',
                'condition' => 'iconic-woo-attribute-swatches-premium/iconic-woo-attribute-swatches.php',
                'name' => 'iconic-woo-attribute-swatches-premium',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/iconic-woo-attribute-swatches-premium/assets/frontend/js/main.min.js',
                     '/iconic-woo-attribute-swatches-premium/assets/vendor/flickity/flickity.pkgd.min.js',
                     'iconic_was_vars',
                ],
            ],
            'two_645cf48d45891_aead199f6a89870e6d65cb9782756202' => [
                'title' => 'WooCommerce Bookings',
                'condition' => 'woocommerce-bookings/woocommerce-bookings.php',
                'type' => 'plugin',
                'name' => 'woocommerce-bookings',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/woocommerce-bookings/dist/frontend.js',
                     '/wp-includes/js/dist/date.min.js',
                     '/wp-includes/js/dist/vendor/moment.min.js',
                     '/wp-includes/js/jquery/ui/datepicker.min.js',
                     '/wp-includes/js/underscore.min.js',
                     '/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js',
                ],
            ],
            'two_645cf48d45892_e3ab7d3b92d8049089dc6eb7a8384d51' => [
                'title' => 'WooCommerce Product Reviews Pro',
                'type' => 'plugin',
                'condition' => 'woocommerce-product-reviews-pro/woocommerce-product-reviews-pro.php',
                'name' => 'woocommerce-product-reviews-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'wc_product_reviews_pro',
                     '/woocommerce-product-reviews-pro/assets/js/frontend/wc-product-reviews-pro-frontend.min.js',
                     '/woocommerce/assets/js/jquery-tiptip/jquery.tipTip.min.js',
                ],
            ],
            'two_645cf48d45893_88ad6319715de5d351dc477ad1933191' => [
                'title' => 'WooCommerce TM Extra Product Options',
                'type' => 'plugin',
                'condition' => 'woocommerce-tm-extra-product-options/tm-woo-extra-product-options.php',
                'name' => 'woocommerce-tm-extra-product-options',
                'scripts' => [
                     '/woocommerce-tm-extra-product-options/assets/js/epo.min.js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/jquery/ui/core.min.js',
                     '/wp-includes/js/jquery/ui/mouse.min.js',
                     '/wp-includes/js/jquery/ui/slider.min.js',
                     '/wp-includes/js/underscore.min.js',
                     '/wp-includes/js/wp-util.min.js',
                     '/wp-includes/js/dist/hooks.js',
                     '/wp-includes/js/dist/i18n.js',
                ],
            ],
            'two_645cf48d45894_eb202e23c6597e45731be5016e420bba' => [
                'title' => 'WooLentor',
                'type' => 'plugin',
                'condition' => 'woolentor-addons/woolentor_addons_elementor.php',
                'name' => 'woolentor-addons',
                'scripts' => [
                     '/woolementor/assets/third-party/slick/slick.min.js',
                     '/woolentor-addons',
                     'woolentor_addons',
                ],
            ],
            'two_645cf48d45895_7640b26d3d04409ea38c56a19ce327d4' => [
                'title' => 'WooThumbs for WooCommerce',
                'condition' => 'woothumbs-premium/woothumbs-premium.php',
                'type' => 'plugin',
                'name' => 'woothumbs-premium',
                'scripts' => [
                     '/wp-includes/js/dist/hooks.min.js',
                     '/wp-includes/js/underscore.min.js',
                     '/wp-includes/js/wp-embed.min.js',
                     '/wp-includes/js/wp-util.min.js',
                     '/woothumbs-premium/(.*)',
                ],
            ],
            'two_645cf48d45896_14e111f6c4e28459d0f8d60b81eb7f7a' => [
                'title' => 'WordPress Mega Menu – QuadMenu',
                'type' => 'plugin',
                'condition' => 'quadmenu/quadmenu.php',
                'name' => 'quadmenu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/quadmenu',
                     '#private-menu',
                     '#public-menu',
                ],
            ],
            'two_645cf48d45897_bea94347de1f6b034ccf355435a70477' => [
                'title' => 'WP Armour',
                'type' => 'plugin',
                'condition' => 'wp-armour-extended/wp-armour-extended.php',
                'name' => 'wp-armour-extended',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/honeypot/includes/js/wpa.js',
                     '/wp-armour-extended/includes/js/wpae.js',
                     'wpa_hidden_field',
                     'wpa_add_test',
                ],
            ],
            'two_645cf48d45898_d33c409659795f4d93ca1af6cfda188a' => [
                'title' => 'WP Go Maps',
                'type' => 'plugin',
                'condition' => 'wp-google-maps/wpGoogleMaps.php',
                'name' => 'wp-google-maps',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'maps.googleapis.com',
                ],
            ],
            'two_645cf48d45899_bdd1ada6a39861b83026d52ffd2609c7' => [
                'title' => 'WP Google Map Pro',
                'condition' => 'wp-google-map-gold/wp-google-map-gold.php',
                'type' => 'plugin',
                'name' => 'wp-google-map-gold',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     'maps.google.com/maps/api/js',
                     '/wp-includes/js/masonry.min.js',
                     '/wp-google-map-gold/(.*)',
                ],
            ],
            'two_645cf48d4589a_58811e242730278d7061d6206ac13b5a' => [
                'title' => 'WP Google Maps Pro',
                'type' => 'plugin',
                'condition' => 'wp-google-maps-pro/wp-google-maps-pro.php',
                'name' => 'wp-google-maps-pro',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-google-maps(.*)',
                     'maps.googleapis.com',
                     'mgl_',
                     'wpgmza',
                ],
            ],
            'two_645cf48d4589b_40b8fd60080354f284aefa2d44a0e951' => [
                'title' => 'WP iCal Availability',
                'type' => 'plugin',
                'condition' => 'wp-ical-availability/wp-ical-availability.php',
                'name' => 'wp-ical-availability',
                'scripts' => [
                     '/wp-ical-availability/js/custom-select.js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-ical-availability/',
                ],
            ],
            'two_645cf48d4589c_37d3ebbe175c8b002ab7f6917d22deea' => [
                'title' => 'WP MapIt',
                'condition' => 'wp-mapit/wp_mapit.php',
                'type' => 'plugin',
                'name' => 'wp-mapit',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-mapit/wp_mapit/js/leaflet.js',
                     '/wp-mapit/wp_mapit/js/wp_mapit_multipin.js',
                ],
            ],
            'two_645cf48d4589d_4c8477716f5dd1b71c685d6066c0e1db' => [
                'title' => 'WP Responsive Menu',
                'type' => 'plugin',
                'condition' => 'wp-responsive-menu/wp-responsive-menu.php',
                'name' => 'wp-responsive-menu',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-responsive-menu/(.*)',
                ],
            ],
            'two_645cf48d4589e_eac09456690e197084c37e0a6fb03a52' => [
                'title' => 'WP Search with Algolia',
                'condition' => 'wp-search-with-algolia/algolia.php',
                'type' => 'plugin',
                'name' => 'wp-search-with-algolia',
                'scripts' => [
                     '/wp-search-with-algolia/js/algoliasearch/dist/algoliasearch-lite.umd.js',
                     '/wp-search-with-algolia/js/autocomplete-noconflict.js',
                     '/wp-search-with-algolia/js/autocomplete.js/dist/autocomplete.min.js',
                     'var algolia',
                ],
            ],
            'two_645cf48d4589f_d7fb4c819a66aff0a0160a8d23631c6c' => [
                'title' => 'WP Smart Preloader',
                'type' => 'plugin',
                'condition' => 'wp-smart-preloader/wp-preloader.php',
                'name' => 'wp-smart-preloader',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/wp-smart-preloader/assets/js/wsp-main-script(.min)?.js',
                ],
            ],
            'two_645cf48d458a0_0e1c55b7ea07b3a470cdd8a6f6f39e75' => [
                'title' => 'WP Store Locator',
                'type' => 'plugin',
                'condition' => 'wp-store-locator/wp-store-locator.php',
                'name' => 'wp-store-locator',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/wp-store-locator/',
                     '/wp-includes/js/underscore.min.js',
                     'maps.google.com',
                ],
            ],
            'two_645cf48d458a1_4a9a34a4e9fe40c25e24bf0a84a9921f' => [
                'title' => 'WPBakery Page Builder',
                'type' => 'plugin',
                'condition' => 'js_composer/js_composer.php',
                'name' => 'js_composer',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/js_composer/assets/js/dist/js_composer_front.min.js',
                ],
            ],
            'two_645cf48d458a2_425f55fd76d1eb3f29d1874a5069a792' => [
                'title' => 'wpDataTables',
                'type' => 'plugin',
                'condition' => 'wpdatatables/wpdatatables.php',
                'name' => 'wpdatatables',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wpdatatables/',
                     'highcharts',
                ],
            ],
            'two_645cf48d458a3_86f3f3a908b94d646722318dd4ad746d' => [
                'title' => 'WPForms',
                'type' => 'plugin',
                'condition' => 'wpforms/wpforms.php',
                'name' => 'wpforms',
                'scripts' => [
                     '/wpforms-offline-forms/assets/js/wpforms-offline-forms.min.js',
                     'wpforms-offline-forms-js-extra',
                     'wpformsRecaptchaLoad',
                ],
            ],
            'two_645cf48d458a4_5dff5fa3a8414b0ad8b81ec5bbe68291' => [
                'title' => 'WPForms Lite',
                'type' => 'plugin',
                'condition' => 'wpforms-lite/wpforms.php',
                'name' => 'wpforms-lite',
                'scripts' => [
                     'wpformsRecaptchaLoad',
                     '/wpforms-offline-forms/assets/js/wpforms-offline-forms.min.js',
                     'wpforms-offline-forms-js-extra',
                ],
            ],
            'two_645cf48d458a5_3407dcdc7517fdccc9c4fc8895af860e' => [
                'title' => 'XL WooCommerce Sales Triggers',
                'condition' => 'xl-woocommerce-sales-triggers/xl-woocommerce-sales-triggers.php',
                'type' => 'plugin',
                'name' => 'xl-woocommerce-sales-triggers',
                'scripts' => [
                     '/xl-woocommerce-sales-triggers/assets/js/wcst_combined.min.js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                ],
            ],
            'two_645cf48d458a6_e5246c8a216af2ad1a956b3cb7b4a3f3' => [
                'title' => 'YITH WooCommerce Ajax Product Filter',
                'type' => 'plugin',
                'condition' => 'yith-woocommerce-ajax-navigation/init.php',
                'name' => 'yith-woocommerce-ajax-navigation',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/yith-woocommerce-ajax-navigation/assets/js/yith-wcan-shortcodes.min.js',
                ],
            ],
            'two_645cf48d458a7_0292d85acc16e73127344845224b8e02' => [
                'title' => 'YITH WooCommerce AJAX Product Filter Premium',
                'type' => 'plugin',
                'condition' => 'yith-woocommerce-ajax-product-filter-premium/init.php',
                'name' => 'yith-woocommerce-ajax-product-filter-premium',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/yith-woocommerce-ajax-product-filter-premium/assets/js/yith-wcan-shortcodes.min.js',
                ],
            ],
            'two_645cf48d458a8_a111a3ee5e75b4dcd69b155b49bef93e' => [
                'title' => 'Yotpo Social Reviews for Woocommerce',
                'condition' => 'yotpo-social-reviews-for-woocommerce/wc_yotpo.php',
                'type' => 'plugin',
                'name' => 'yotpo-social-reviews-for-woocommerce',
                'scripts' => [
                     '/yotpo-social-reviews-for-woocommerce/assets/js/headerScript.js',
                ],
            ],
        ),
        'themes' => array(
            'two_645cf52ebfc5c_acbd78e51f286f2db143304fc092ce21' => [
                'title' => 'Andaman',
                'type' => 'theme',
                'condition' => 'andaman',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/andaman/assets/js/',
                     '/wp-andaman-plugins/shortcodes/vc_extend/',
                ],
            ],
            'two_645cf52ebfc6f_878d780344ee270a206eb5decde77dd8' => [
                'title' => 'Artale',
                'type' => 'theme',
                'condition' => 'artale',
                'scripts' => [
                     '/artale-elementor/assets/js/modulobox.js',
                     '/artale-elementor/assets/js/artale-elementor.js',
                     '/artale/js/jquery-stellar.js',
                     '/artale/js/core/artale-plugins.js',
                     '/artale/js/core/artale-custom.js',
                     'var loader',
                ],
            ],
            'two_645cf52ebfc72_9dbb40d076c4df840899d7f16de0f206' => [
                'title' => 'Astra',
                'condition' => 'astra',
                'type' => 'theme',
                'scripts' => [
                     '/astra/assets/js/minified/frontend.min.js',
                ],
            ],
            'two_645cf52ebfc73_4fb1219e596ab09acda232fa6d188f4d' => [
                'title' => 'Astra - Carousel',
                'type' => 'theme',
                'condition' => 'astra',
                'scripts' => [
                     'var astra',
                     '/astra/assets/js/minified/style.min.js',
                ],
            ],
            'two_645cf52ebfc75_b99f0c7b1af5bc0b2cd584985a9ce063' => [
                'title' => 'Auteur',
                'condition' => 'g5plus-auteur',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/g5plus-auteur/assets/js/core.min.js',
                     '/g5plus-auteur/assets/vendors/',
                     '/auteur-framework/libs/smart-framework/assets/vendors/perfect-scrollbar/js/perfect-scrollbar.jquery.min.js',
                     '/wp-includes/js/imagesloaded.min.js',
                ],
            ],
            'two_645cf52ebfc76_91a9659f8af296d8c8bbf929eb8dab86' => [
                'title' => 'AutoTrader',
                'condition' => 'autotrader',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/autotrader/(.*).js',
                ],
            ],
            'two_645cf52ebfc78_9792e4242d5bc05aab874b54c677407b' => [
                'title' => 'Avada - Animations & mobile-specific actions',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/uploads/fusion-scripts/(.*).js',
                     'window.off_canvas_',
                     '/plugins/fusion-builder/',
                     '/plugins/fusion-core/',
                     '/Avada/includes/',
                ],
            ],
            'two_645cf52ebfc79_00067b261d9353ab4ef054dcc36adbe0' => [
                'title' => 'Avada - FAQ shortcode',
                'condition' => 'Avada',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/plugins/fusion-core/js/min/avada-faqs.js',
                ],
            ],
            'two_645cf52ebfc7a_f5ce7fefe7a07fe1a55352f21f572b48' => [
                'title' => 'Avada - Fusion carousel',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/includes/lib/assets/min/js/library/jquery.carouFredSel.js',
                     '/includes/lib/assets/min/js/general/fusion-carousel.js',
                     'fusionCarouselVars',
                ],
            ],
            'two_645cf52ebfc7c_2c8ae978f9f48a5fe31fe72b3021edde' => [
                'title' => 'Avada - Fusion form',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/fusion-builder/assets/js/min/general/fusion-form.js',
                     '/fusion-builder/assets/js/min/general/fusion-form-logics.js',
                     '/includes/lib/assets/min/js/library/cssua.js',
                     '/includes/lib/assets/min/js/general/fusion.js',
                     '/includes/lib/assets/min/js/library/modernizr.js',
                ],
            ],
            'two_645cf52ebfc7d_91980282d90630c5e67507929b2ddc73' => [
                'title' => 'Avada - Fusion grid gallery',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/fusion-builder/assets/js/min/general/fusion-gallery.js',
                     '/includes/lib/assets/min/js/library/imagesLoaded.js',
                     '/includes/lib/assets/min/js/library/isotope.js',
                     '/includes/lib/assets/min/js/library/packery.js',
                     '/includes/lib/assets/min/js/library/lazysizes.js',
                ],
            ],
            'two_645cf52ebfc7e_80a87456bd48c6020155d9cf12d17a80' => [
                'title' => 'Avada - Fusion slider',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/fusion-core/js/min/avada-fusion-slider.js',
                     '/Avada/includes/',
                ],
            ],
            'two_645cf52ebfc7f_437dc3e4ca4d993bfdc4dcf150372ed1' => [
                'title' => 'Avada - Mobile menu',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/assets/min/js/general/avada-menu.js',
                     '/includes/lib/assets/min/js/library/modernizr.js',
                     '/includes/lib/assets/min/js/library/jquery.easing.js',
                ],
            ],
            'two_645cf52ebfc82_fae8bcaf68bcd72f65678a2aeb3900cf' => [
                'title' => 'Avada - OffCanvas',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/uploads/fusion-scripts/(.*).min.js',
                     'window.off_canvas_',
                ],
            ],
            'two_645cf52ebfc83_abe9205a4476e34eabab9ccc18a53be2' => [
                'title' => 'Avada - portfolio',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/library/packery.js',
                     '/library/isotope.js',
                     '/library/imagesLoaded.js',
                     '/general/fusion-lightbox.js',
                     '/fusion-core/js/min/avada-portfolio.js',
                ],
            ],
            'two_645cf52ebfc84_332c9d1e787fbcf7f3dd3128f7be0413' => [
                'title' => 'Avada - Portfolio',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/includes/lib/assets/min/js/library/imagesLoaded.js',
                     '/includes/lib/assets/min/js/library/isotope.js',
                     '/includes/lib/assets/min/js/library/lazysizes.js',
                     '/includes/lib/assets/min/js/library/modernizr.js',
                     '/includes/lib/assets/min/js/library/packery.js',
                     '/fusion-core/js/min/avada-portfolio.js',
                     'avadaPortfolioVars',
                ],
            ],
            'two_645cf52ebfc85_064ad937ff031aabca2ad4624fa013db' => [
                'title' => 'Avada - Sticky menu',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/Avada/assets/min/js/general/avada-menu.js',
                ],
            ],
            'two_645cf52ebfc87_e15a94c53b754deae40fa3527edb7793' => [
                'title' => 'Avada - WooCommerce product gallery',
                'type' => 'theme',
                'condition' => 'Avada',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/assets/min/js/general/avada-woo-product-images.js',
                     '/includes/lib/assets/min/js/library/jquery.flexslider.js',
                ],
            ],
            'two_645cf52ebfc88_bf12a203eec292929ab47cf3fe0472b8' => [
                'title' => 'Avesa',
                'condition' => 'avesa',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/avesa/js/main.js',
                     '/avesa/js/isotope.js',
                     '/sw_core/js/slick.min.js',
                     '/avesa/js/bootstrap-datetimepicker.min.js',
                     '/avesa/js/bootstrap.min.js',
                ],
            ],
            'two_645cf52ebfc89_277533231864691cc03b3f8c71ca5b6c' => [
                'title' => 'Besa',
                'condition' => 'besa',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/besa/js/',
                ],
            ],
            'two_645cf52ebfc8b_febf425533cbb2ef3cc17c057d2df7ae' => [
                'title' => 'BeTheme',
                'condition' => 'betheme',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/betheme/',
                     'mfn',
                     '/wp-includes/js/jquery/ui/tabs.min.js',
                     '/wp-includes/js/jquery/ui/core.min.js',
                ],
            ],
            'two_645cf52ebfc8c_98ac6b4b086b5a2f47677b15e786d9ba' => [
                'title' => 'Bridge',
                'type' => 'theme',
                'condition' => 'bridge',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/bridge-creative/bridge/js/',
                     '/wp-includes/js/',
                ],
            ],
            'two_645cf52ebfc8d_6cd078a154fcbe52095c4ecf2ee4e932' => [
                'title' => 'Car Dealer',
                'condition' => 'cardealer',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/jquery/(.*)',
                     '/cardealer/js/(.*)',
                ],
            ],
            'two_645cf52ebfc8e_fed04e8acd998c16a32a8613c0ef1582' => [
                'title' => 'Clover',
                'condition' => 'clover-theme',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/clover-theme/',
                ],
            ],
            'two_645cf52ebfc90_54159e1dbd22773e60b534a3fcd7cb7c' => [
                'title' => 'Divi - Animations',
                'condition' => 'Divi',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '.dipi_preloader_wrapper_outer',
                     '/Divi/js/scripts.min.js',
                     '/Divi/js/custom.unified.js',
                     '/js/magnific-popup.js',
                     'var DIVI',
                ],
            ],
            'two_645cf52ebfc91_c53e64472f6a40edef0ce7203d17629a' => [
                'title' => 'Divi - Background video',
                'condition' => 'Divi',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate.min.js',
                     '/Divi/js/custom.unified.js',
                     '/js/mediaelement/(.*)',
                     'mejs',
                ],
            ],
            'two_645cf52ebfc92_b17f68fb4c849f50e100300fe0a37c98' => [
                'title' => 'Divi - Counter module',
                'condition' => 'Divi',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '.dipi_preloader_wrapper_outer',
                     '/Divi/js/scripts.min.js',
                     '/Divi/js/custom.unified.js',
                     '/js/magnific-popup.js',
                     'var DIVI',
                     '/Divi/includes/builder/feature/dynamic-assets/assets/js/easypiechart.js',
                ],
            ],
            'two_645cf52ebfc93_a36f062b0fcc740077cccf5a11c7ffea' => [
                'title' => 'Divi - Mobile menu',
                'condition' => 'Divi',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate.min.js',
                     '/Divi/js/scripts.min.js',
                     '/Divi/js/custom.unified.js',
                ],
            ],
            'two_645cf52ebfc94_0fe2a223c302535effbf88ee4af90189' => [
                'title' => 'Divi - Sticky elements',
                'condition' => 'Divi',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '.dipi_preloader_wrapper_outer',
                     '/Divi/js/scripts.min.js',
                     '/Divi/includes/builder/feature/dynamic-assets/assets/js/sticky-elements.js',
                     'var DIVI',
                ],
            ],
            'two_645cf52ebfc95_3e198404cbfd8bf951af8104c57e5d7f' => [
                'title' => 'Divi - Sticky menu',
                'condition' => 'Divi',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/js/jquery/jquery-migrate.min.js',
                     '/Divi/js/scripts.min.js',
                     '/Divi/includes/builder/feature/dynamic-assets/assets/js/magnific-popup.js',
                     'jqueryParams',
                     'firstHeader',
                ],
            ],
            'two_645cf52ebfc96_5b2e6874427df91f36e2d9336b70b05a' => [
                'title' => 'Eikra',
                'condition' => 'eikra',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate.min.js',
                     '/eikra/assets/js/',
                     'EikraObj',
                ],
            ],
            'two_645cf52ebfc98_6a1132eb50b971d62f8425b2c9a9b5ae' => [
                'title' => 'Ekko',
                'condition' => 'ekko',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/ekko/',
                ],
            ],
            'two_645cf52ebfc99_2776e430c5a377633ffccd146522e60a' => [
                'title' => 'Elessi',
                'condition' => 'elessi-theme',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/elessi-theme/assets/js/min/functions.min.js',
                     '/elessi-theme/assets/js/min/main.min.js',
                ],
            ],
            'two_645cf52ebfc9a_3d7957ec79e6c8fa20c4dfd7e568da12' => [
                'title' => 'Enfold',
                'type' => 'theme',
                'condition' => 'enfold',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/dynamic_avia/avia-footer-scripts-(.*).js',
                     'var avia_is_mobile',
                ],
            ],
            'two_645cf52ebfc9b_f19249d1a084beca3705548471248455' => [
                'title' => 'Enfold - LayerSlider',
                'type' => 'theme',
                'condition' => 'enfold',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'layerslider',
                ],
            ],
            'two_645cf52ebfc9d_9e7ffe85b1afc5b5c78fc887cef28dee' => [
                'title' => 'Enfold - Shortcodes',
                'condition' => 'enfold',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/enfold/js/avia.js',
                     '/enfold/js/shortcodes.js',
                     '/enfold/config-templatebuilder/avia-shortcodes/',
                     '/enfold/js/avia-compat.js',
                ],
            ],
            'two_645cf52ebfc9e_35518ba8fcfe775d82860770fafd922f' => [
                'title' => 'Envision',
                'condition' => 'envision',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/envision/lib/js/app.min.js',
                     'var CloudFwOp',
                ],
            ],
            'two_645cf52ebfc9f_3b24786e367d0dff22c7fe1fe10ed87c' => [
                'title' => 'Ewebot',
                'type' => 'theme',
                'condition' => 'ewebot',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/gt3-themes-core/',
                     '/uploads/gt3-assets/js/(.*)',
                     '/wp-includes/js/imagesloaded.min.js',
                ],
            ],
            'two_645cf52ebfca0_eeb04c1088165ac52e94cda1c7ca4705' => [
                'title' => 'Farvis',
                'condition' => 'farvis',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/farvis/',
                ],
            ],
            'two_645cf52ebfca1_f9f4ca9cb1bbd03a472d7ed709302076' => [
                'title' => 'Flatsome',
                'condition' => 'flatsome',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/flatsome/assets/js/flatsome.js',
                     '/flatsome/assets/libs/packery.pkgd.min.js',
                     '/flatsome/assets/js/woocommerce.js',
                ],
            ],
            'two_645cf52ebfca2_27f69bc6d6882ba0ca8f09faa9a860b2' => [
                'title' => 'Flatsome - Google map',
                'type' => 'theme',
                'condition' => 'flatsome',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'maps.googleapis.com',
                     'google.maps.LatLng',
                     '/wp-includes/js/hoverIntent.min.js',
                ],
            ],
            'two_645cf52ebfca3_9b5e9a400080f0245e05334185b5c6e1' => [
                'title' => 'Flatsome - Images',
                'condition' => 'flatsome',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/flatsome/inc/integrations/wp-rocket/flatsome-wp-rocket.js',
                     '/flatsome/assets/js/flatsome.js',
                     '/flatsome/inc/extensions/flatsome-lazy-load/flatsome-lazy-load.js',
                ],
            ],
            'two_645cf52ebfca4_f60834ce35581c434a68022f2e84f796' => [
                'title' => 'Frida',
                'condition' => 'frida',
                'type' => 'theme',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/frida/',
                ],
            ],
            'two_645cf52ebfca5_711058531cd7077da2c647d253e34d02' => [
                'title' => 'GeneratePress - Mobile menu',
                'type' => 'theme',
                'condition' => 'generatepress',
                'scripts' => [
                     '/generatepress/assets/js/menu.min.js',
                     'generatepressMenu',
                     '/gp-premium/menu-plus/functions/js/offside.min.js',
                ],
            ],
            'two_645cf52ebfca7_b2f39f17253fa5e90a05d637249c53e1' => [
                'title' => 'Honor - WPBakery fix',
                'condition' => 'honor',
                'type' => 'theme',
                'scripts' => [
                     '/honor/js/__scripts.js',
                     'HONOR_STORAGE',
                     '/js_composer/',
                ],
            ],
            'two_645cf52ebfca8_6259970b6e6c26246527cc968002e3be' => [
                'title' => 'HotelMaster',
                'condition' => 'hotelmaster',
                'type' => 'theme',
                'scripts' => [
                     '/wp-includes/js/jquery/jquery.min.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/hotelmaster/javascript/gdlr-script.js',
                     '/hotelmaster/plugins/dl-menu/modernizr.custom.js',
                     '/hotelmaster/plugins/dl-menu/jquery.dlmenu.js',
                     '/hotelmaster/plugins/superfish/js/superfish.js',
                     '/hotelmaster/plugins/jquery.easing.js',
                ],
            ],
            'two_645cf52ebfca9_19c2de9a7a4a531bd8dd79c5e73c7743' => [
                'title' => 'HotelMaster - Blog',
                'type' => 'theme',
                'condition' => 'hotelmaster',
                'scripts' => [
                     '/wp-includes/js/masonry.min.js',
                     '/gp-premium/blog/functions/js/scripts.min.js',
                     '/wp-includes/js/imagesloaded.min.js',
                ],
            ],
            'two_645cf52ebfcaa_1ec6a1b62445f2d4a604f6d700f970e3' => [
                'title' => 'HotelMaster - Masonry',
                'type' => 'theme',
                'condition' => 'hotelmaster',
                'scripts' => [
                     '/gp-premium/menu-plus/functions/js/offside.min.js',
                     'offSide',
                ],
            ],
            'two_645cf52ebfcab_fd676332bcd2355bb23c518bb56e473d' => [
                'title' => 'JNews',
                'condition' => 'jnews',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate.min.js',
                     '/jnews/assets/js/',
                     'jnews',
                     'jfla',
                ],
            ],
            'two_645cf52ebfcac_57857f23893dc775c9da27ac6f534801' => [
                'title' => 'JOYN',
                'condition' => 'joyn',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/swift-framework/includes/page-builder/frontend-assets/js/lib/modernizr-custom.js',
                     '/swift-framework/includes/page-builder/frontend-assets/js/spb-functions.min.js',
                     '/swift-framework/includes/swift-slider/assets/js/swift-slider.min.js',
                     '/swift-framework/public/js/lib/imagesloaded.pkgd.min.js',
                     '/joyn/js/owl.carousel.min.js',
                     '/joyn/js/theme-scripts.js',
                     '/joyn/js/functions.js',
                ],
            ],
            'two_645cf52ebfcad_08bff026587dbe449c0ded469da8e651' => [
                'title' => 'Juno Toys',
                'condition' => 'junotoys',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate.min.js',
                     '/junotoys/fw/js/core.init.js',
                     '/junotoys/fw/js/core.utils.js',
                     '/junotoys/fw/js/superfish.js',
                     '/junotoys/fw/js/swiper/swiper.js',
                     '/trx_utils/shortcodes/theme.shortcodes.js',
                     '/wp-includes/js/jquery/ui/(.*)',
                ],
            ],
            'two_645cf52ebfcae_27a5148ea0fbddae22d902bea9a19531' => [
                'title' => 'Jupiter',
                'condition' => 'jupiter',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/jupiter/',
                     '/wp-includes/js/underscore.min.js',
                     'WebFont.load',
                ],
            ],
            'two_645cf52ebfcb0_6da4bae08687f8e53e37b19ce244c2c4' => [
                'title' => 'JupiterX',
                'condition' => 'jupiterx',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/jupiterx/(.*).js',
                     '/wp-includes/js/underscore.min.js',
                     'WebFont.load',
                ],
            ],
            'two_645cf52ebfcb1_680ceb71ce1204462378982494c8ae9d' => [
                'title' => 'Kadence',
                'condition' => 'kadence',
                'type' => 'theme',
                'scripts' => [
                     '/kadence/assets/js/navigation.min.js',
                     'mobile_menu_breakpoint ',
                     'kadenceConfig',
                ],
            ],
            'two_645cf52ebfcb2_33d0292c5089802c372957e1bd8d98d9' => [
                'title' => 'Kalium',
                'condition' => 'kalium',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/kalium/assets/js/main.min.js',
                     'mobile_menu_breakpoint',
                     'var _k',
                ],
            ],
            'two_645cf52ebfcb3_f5b768225a3f3f7770217293d3bf7882' => [
                'title' => 'Kava',
                'condition' => 'kava',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/kava/assets/js/theme-script.js',
                ],
            ],
            'two_645cf52ebfcb4_ac0d0a292a3725daf32d58083e8e194c' => [
                'title' => 'Lay',
                'condition' => 'lay',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/backbone.min.js',
                     '/wp-includes/js/underscore.min.js',
                     '/lay/',
                     '/laytheme-carousel/',
                     'window.laytheme',
                ],
            ],
            'two_645cf52ebfcb5_55c94c288830cd8f91be711ec4f36397' => [
                'title' => 'LazaNews',
                'type' => 'theme',
                'condition' => 'lazanews',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/jquery.custom.js',
                ],
            ],
            'two_645cf52ebfcb6_5eb487dd823b01e18c3b420abe54e094' => [
                'title' => 'Listeo',
                'condition' => 'listeo',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/listeo/js/',
                ],
            ],
            'two_645cf52ebfcb8_30006f533fc74ae2fd958fe243359a4c' => [
                'title' => 'ListingPro',
                'condition' => 'listingpro',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/listingpro/assets/lib/jquerym.menu/js/jquery.mmenu.min.all.js',
                     '/listingpro/assets/lib/Magnific-Popup-master/jquery.magnific-popup.min.js',
                     '/listingpro/assets/js/select2.full.min.js',
                     '/listingpro/assets/js/jquery.city-autocomplete.js',
                     '/listingpro/assets/js/chosen.jquery.min.js',
                     '/listingpro/assets/lib/bootstrap/js/bootstrap-slider.js',
                     '/listingpro/assets/js/jquery-ui.js',
                     '/listingpro/assets/js/mapbox.js',
                     '/listingpro/assets/js/main.js',
                     '/listingpro/assets/js/leaflet.markercluster.js',
                     'maps',
                ],
            ],
            'two_645cf52ebfcb9_f0195533990fcb4c68f247f2a88d41da' => [
                'title' => 'Master Study',
                'condition' => 'masterstudy',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/masterstudy/assets/js/custom.js ',
                     '/masterstudy/assets/vendors/jquery.fancybox.min.js ',
                     '/masterstudy/assets/js/select2.full.min.js',
                ],
            ],
            'two_645cf52ebfcba_b2693d9c2124f3ca9547b897794ac6a1' => [
                'title' => 'Maya',
                'condition' => 'maya',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/maya/js/jquery.mobilemenu.js',
                     '/maya/js/jquery.custom.js',
                     '/maya/core/includes/js/jquery.tipsy.js',
                ],
            ],
            'two_645cf52ebfcbb_0609a28a3a7d610f34d9e18b3a93e64b' => [
                'title' => 'MH Magazine',
                'condition' => 'mh-magazine',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/mh-magazine/',
                ],
            ],
            'two_645cf52ebfcbc_9975f9e9820268ad96678ab5704a0cd6' => [
                'title' => 'Minimog',
                'condition' => 'minimog',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/minimog/',
                ],
            ],
            'two_645cf52ebfcbe_3202cb64798991ec49b0ad8a3ea62ba8' => [
                'title' => 'Moozo Elementor',
                'condition' => 'moozo-elementor',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/moozo-elementor/assets/js/countdown.js',
                     '/moozo-elementor/assets/vendor/countdown/countdown.min.js',
                ],
            ],
            'two_645cf52ebfcc0_65d51e16e6cfca0bd2c9e3aa686d373c' => [
                'title' => 'My Listing',
                'condition' => 'my-listing',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/my-listing/assets/',
                     '/wp-includes/js/dist/vendor/moment.min.js',
                     'maps.googleapis.com',
                     'MyListing',
                     '_Explore_Settings',
                ],
            ],
            'two_645cf52ebfcc1_7a678213cf73b14959c80a19cf14283d' => [
                'title' => 'Neve - Mobile menu',
                'condition' => 'neve',
                'type' => 'theme',
                'scripts' => [
                     '/neve/assets/js/build/modern/frontend.js',
                ],
            ],
            'two_645cf52ebfcc2_13c402efbe0a12ce75e0fbe1fbe07402' => [
                'title' => 'Newspaper - Images',
                'type' => 'theme',
                'condition' => 'Newspaper',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'tagdiv_theme.min.js',
                     'tdBlocksArray',
                ],
            ],
            'two_645cf52ebfcc3_8658f8b89a5b050ef1e914a0a1b9b47a' => [
                'title' => 'Newspaper - Slider & YouTube',
                'type' => 'theme',
                'condition' => 'Newspaper',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'tagdiv_theme.min.js',
                     'tdBlocksArray',
                     'tdb_globals',
                     'td_youtube_list_ids',
                     'iosSlider',
                     '/td-cloud-library/assets/js/js_files_for_front.min.js',
                ],
            ],
            'two_645cf52ebfcc4_4545e51aba6d28e35f0ac30d0d61db8f' => [
                'title' => 'Niva',
                'condition' => 'niva',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/niva/js/',
                     '/sweetthemes-framework/js/',
                     'mt_typed',
                ],
            ],
            'two_645cf52ebfcc6_158994cc0cef5058d578bf05afa83c51' => [
                'title' => 'OceanWP',
                'condition' => 'oceanwp',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/oceanwp/',
                ],
            ],
            'two_645cf52ebfcc7_1f65728abd491a2d3e1c12c954a87844' => [
                'title' => 'OceanWP - Mobile menu',
                'condition' => 'oceanwp',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/ocean-side-panel/assets/js/side-panel.min.js',
                     '/oceanwp/assets/js/theme.vanilla.min.js',
                ],
            ],
            'two_645cf52ebfcc9_1605d0346f3bfedf07891c89338cc61b' => [
                'title' => 'PenNews',
                'condition' => 'pennews',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/pennews/js/script.min.js',
                     '/pennews/js/script.lib.min.js',
                ],
            ],
            'two_645cf52ebfcca_267b1357db0fba4d4cf6dff9e1388167' => [
                'title' => 'Pharmacy Mentor',
                'condition' => 'pharmacymentor',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/pharmacymentor/',
                ],
            ],
            'two_645cf52ebfccb_71d6c631e36a3432a5899bb09c51d52a' => [
                'title' => 'Porto',
                'condition' => 'porto',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/jquery/ui/',
                     '/porto/js/theme.js',
                     '/porto/js/theme.min.js',
                ],
            ],
            'two_645cf52ebfccc_8d0c7113047d7fd6e808586c922e441e' => [
                'title' => 'ProPhoto',
                'condition' => 'prophoto7',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/prophoto7/js/bundle.front.js',
                     '/wp-includes/js/underscore.min.js',
                     'PROPHOTO',
                ],
            ],
            'two_645cf52ebfccd_52aded165360352a0f5857571d96d68f' => [
                'title' => 'Publisher',
                'condition' => 'publisher',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     '/publisher/js/',
                ],
            ],
            'two_645cf52ebfcce_67b475a9c68869d790f0c8dd8e1a8aec' => [
                'title' => 'REHub',
                'condition' => 'rehub-theme',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/rehub-theme/js/custom_floatpanel.js',
                ],
            ],
            'two_645cf52ebfcd0_d2b3ea2dfddc40efdc6941359436c847' => [
                'title' => 'Rey',
                'condition' => 'rey',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/rey/scripts-(.*).js',
                     '/rey-core/assets/js/',
                ],
            ],
            'two_645cf52ebfcd1_66a4efcbe5ad42a128671f0474edaa00' => [
                'title' => 'Rife Free',
                'condition' => 'rife-free',
                'type' => 'theme',
                'scripts' => [
                     '/rife-free/js/script.min.js',
                     '/rife-free/js/isotope.pkgd.min.js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'var reJS',
                ],
            ],
            'two_645cf52ebfcd2_325256f28f290cc43b376503829b3658' => [
                'title' => 'Salient',
                'condition' => 'salient',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                     '/salient/',
                     'winW > bodyW',
                ],
            ],
            'two_645cf52ebfcd3_b9a2481224a4621274d2855f04fd6e13' => [
                'title' => 'Salient - Nectar slider',
                'type' => 'theme',
                'condition' => 'salient',
                'scripts' => [
                     '/salient-nectar-slider/js/nectar-slider.js',
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js ',
                     '/jquery-migrate(.min)?.js',
                ],
            ],
            'two_645cf52ebfcd4_0d08849d7aa22a2033ba8077d857d3bb' => [
                'title' => 'Shoptimizer',
                'condition' => 'shoptimizer',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/shoptimizer/assets/js/lazyload-bg.js',
                     '/shoptimizer/assets/js/main.min.js',
                ],
            ],
            'two_645cf52ebfcd5_08ed12688b0ba10e5673f537296b9a7c' => [
                'title' => 'SmartMag',
                'condition' => 'smart-mag',
                'type' => 'theme',
                'scripts' => [
                     '/smart-mag/js/lazyload.js',
                ],
            ],
            'two_645cf52ebfcd7_e2946d6c7dc5e292bd84fb68bb4e8bcf' => [
                'title' => 'Soledad',
                'condition' => 'soledad',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/soledad/js/main.js',
                     '/soledad/js/more-post.js',
                     '/soledad/js/libs-script.min.js',
                ],
            ],
            'two_645cf52ebfcd8_edcd259e0a03c7ab70feb186bae19f13' => [
                'title' => 'Stockholm',
                'condition' => 'stockholm',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/stockholm/js/',
                ],
            ],
            'two_645cf52ebfcd9_a8f2e11a54b6346b676c448890c2d688' => [
                'title' => 'Storefront',
                'condition' => 'storefront',
                'type' => 'theme',
                'scripts' => [
                     '/storefront/assets/js/navigation.min.js',
                ],
            ],
            'two_645cf52ebfcda_7847f4d4db90521f0a536e925a07408d' => [
                'title' => 'StreamTube',
                'condition' => 'streamtube',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/streamtube/',
                     '/streamtube-core/',
                ],
            ],
            'two_645cf52ebfcdb_3de21daaa2ac8a58d8ef49f123f285aa' => [
                'title' => 'The7',
                'condition' => 'dt-the7',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/wp-includes/js/jquery/jquery-migrate.min.js',
                     'loader-removed',
                     '/Ultimate_VC_Addons/assets/min-js/',
                     '/dt-the7/',
                     '/js_composer/',
                ],
            ],
            'two_645cf52ebfcdc_5fcc17c03b0bc3d25d2beec8cd644cb8' => [
                'title' => 'TheGem',
                'condition' => 'thegem',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/thegem/js/',
                     'gemSettings',
                     'thegemSlideshow',
                     'tgpLazyItemsOptions',
                ],
            ],
            'two_645cf52ebfcdd_96b0141273eabab320119c467cdcaf17' => [
                'title' => 'Total',
                'condition' => 'Total',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/Total/assets/js/total.min.js',
                ],
            ],
            'two_645cf52ebfcde_99d3bb685b7f54b4a60db407f216789a' => [
                'title' => 'Townhub',
                'type' => 'theme',
                'condition' => 'townhub',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/townhub-add-ons/assets/js/(.*)',
                     '/wp-includes/js/dist/vendor/react.js',
                     '/wp-includes/js/dist/vendor/react-dom.js',
                ],
            ],
            'two_645cf52ebfcdf_4c69db951aa512d7e639da257af0a94a' => [
                'title' => 'Uncode',
                'condition' => 'uncode',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/uncode/library/js/init(.min)?.js',
                     '/uncode/library/js/plugins(.min)?.js',
                     '/uncode/library/js/app(.min)?.js',
                     '/uncode/library/js/woocommerce-uncode(.min)?.js',
                     '/wp-includes/js/mediaelement/mediaelement-and-player.min.js',
                     'initHeader',
                     'initBox',
                     'fixMenuHeight',
                     'initRow',
                ],
            ],
            'two_645cf52ebfce1_90a8539867db3f9db51aa2514624faa9' => [
                'title' => 'Werkstatt',
                'condition' => 'werkstatt',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/js/underscore.min.js',
                     '/werkstatt/assets/js/vendor.min.js',
                     '/werkstatt/assets/js/fullscreen.min.js',
                     '/werkstatt/assets/js/app.min.js',
                ],
            ],
            'two_645cf52ebfce2_333853c80f848940c3c473c4f7af7c9d' => [
                'title' => 'Woodmart',
                'condition' => 'woodmart',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/wp-includes/js/imagesloaded.min.js',
                     '/woodmart/js/scripts/wc/',
                     '/woodmart/js/scripts/global/',
                     '/woodmart/js/libs/owl.carousel.min.js',
                     '/woodmart/js/libs/owl.carousel.js',
                     '/woodmart/js/libs/slick.js',
                ],
            ],
            'two_645cf52ebfce3_746924bf62a7c5b7629ddf7d110536fe' => [
                'title' => 'XStore',
                'condition' => 'xstore',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/xstore/js/',
                     '/et-core-plugin/packages/st-woo-swatches/public/js/frontend.min.js',
                ],
            ],
            'two_645cf52ebfce4_b2c76ad9a9ed76cddff519b3f1b56a54' => [
                'title' => 'YOOtheme Pro',
                'type' => 'theme',
                'condition' => 'yootheme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     'uikit.min.js',
                ],
            ],
            'two_645cf52ebfce5_b257bacd2679ad401520dec73d25c46e' => [
                'title' => 'Zeen',
                'condition' => 'zeen',
                'type' => 'theme',
                'scripts' => [
                     '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js',
                     '/jquery-migrate(.min)?.js',
                     '/zeen/assets/js/',
                     '/js.cookie.min.js',
                ],
            ],
        ),
        'types' => array(
            'application\/ld\+json',
            'text\/template',
            'text\/x\-template',
            'text\/html',
            'application\/json',
            'text\/totalpoll\-config',
        ),
    );
    public static $site_plugins = array();
    public static $plugins_exclusion_list = array();
    public static $scripts_exclusion_list = array();
    public static $themes_exclusion_list = array();
    public static $exclusion_data = array();

    public static function get_exclusion_list($options, $content){
        $folder_exclude = false;
        $delay_all_js_execution = $options["delay_all_js_execution"];
        $exclude_data = self::EXCLUDE_LIST["types"];
        if(isset($options["exclude_delay_js"]) && is_array($options["exclude_delay_js"])){
            $exclude_data = array_merge($options["exclude_delay_js"], $exclude_data);
        }
        if($delay_all_js_execution && isset($options["two_delay_js_exclusions"]) && is_array($options["two_delay_js_exclusions"])){
            $two_delay_js_exclusions = $options["two_delay_js_exclusions"];
            $plugins_list = self::EXCLUDE_LIST["plugins"];
            $scripts_list = self::EXCLUDE_LIST["scripts"];
            $themes_list = self::EXCLUDE_LIST["themes"];
            foreach ($two_delay_js_exclusions as $id => $key){
                if (isset($plugins_list[$key]["scripts"])) {
                    if(isset($plugins_list[$key]['regex_to_find'])){
                        preg_match($plugins_list[$key]['regex_to_find'], $content, $matches);
                        if(empty($matches)) {
                            continue;
                        }
                    }
                    $exclude_data[] = $plugins_list[$key]["scripts"];
                } else if (isset($scripts_list[$key]["scripts"])) {
                    if(isset($scripts_list[$key]['regex_to_find'])){
                        preg_match($scripts_list[$key]['regex_to_find'], $content, $matches);
                        if(empty($matches)) {
                            continue;
                        }
                    }
                    $exclude_data[] = $scripts_list[$key]["scripts"];
                } else if (isset($themes_list[$key]["scripts"])){
                    $exclude_data[] = $themes_list[$key]["scripts"];
                } else if($key !== "tenweb-speed-optimizer/tenweb_speed_optimizer.php") {
                    $plugin_folder_name_arr = explode("/", $key);
                    $plugin_folder_name = "/".$plugin_folder_name_arr[0]."/";
                    $exclude_data[] = $plugin_folder_name;
                    $folder_exclude = true;
                }
            }
            if($folder_exclude){
                $exclude_data[] = ['/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js', '/jquery-migrate(.min)?.js'];
            }

            $exclude_data = OptimizerUtils::two_flatten($exclude_data);
            $exclude_data = array_unique($exclude_data);
        }
        return $exclude_data;
    }
    public static function get_exclusion_data(){
        self::$site_plugins = get_plugins();
        if(is_array(self::$site_plugins)){
            unset(self::$site_plugins["tenweb-speed-optimizer/tenweb_speed_optimizer.php"]);
        }
        self::$plugins_exclusion_list = self::EXCLUDE_LIST["plugins"];
        self::$scripts_exclusion_list = self::EXCLUDE_LIST["scripts"];
        self::$themes_exclusion_list = self::EXCLUDE_LIST["themes"];
        self::$exclusion_data = self::$site_plugins;
        array_filter(self::$plugins_exclusion_list,  "self::filter_exclusion_plugins" ,ARRAY_FILTER_USE_BOTH);
        self::$exclusion_data = array_merge(self::$exclusion_data, self::$scripts_exclusion_list);
        $current_theme = wp_get_theme();
        $theme_text_domain = $current_theme->get("TextDomain");
        foreach (self::$themes_exclusion_list as $key=>$val){
            if(isset($val["condition"]) && $val["condition"] === "$theme_text_domain"){
                self::$exclusion_data[$key] = $val;
            }
        }
        return self::$exclusion_data;
    }


    public static function filter_exclusion_plugins($val, $key){
        $plugin_key = $val["condition"];
        if(isset(self::$site_plugins[$plugin_key])){
            unset(self::$exclusion_data[$plugin_key]);
            self::$exclusion_data[$key] = $val;
        }
    }
    public static function plugin_is_excluded($condition){
        global $TwoSettings;
        $site_plugins = get_plugins();
        $plugins_exclusion_list = self::EXCLUDE_LIST["plugins"];
        $two_delay_js_exclusions = $TwoSettings->get_settings("two_delay_js_exclusions");
        if(is_array($two_delay_js_exclusions)){
            foreach ($two_delay_js_exclusions as $item){
                if(isset($plugins_exclusion_list[$item])){
                    if($plugins_exclusion_list[$item]["condition"] === $condition){
                        return true;
                    }
                }else{
                    $key = explode("/", $condition);
                    $plugin_folder_name = "/".$key[0]."/";
                    if(in_array($plugin_folder_name, $two_delay_js_exclusions)){
                        return true;
                    }
                }
            }
        }
        return false;
    }



}